% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalise.R
\name{normalise}
\alias{normalise}
\alias{normalize}
\title{Normalise hospital names}
\usage{
normalise(
  nm,
  return = c("hospital_short_name", "hospital_full_name", "hospital_id",
    "hospital_acronym"),
  unmatched_as_na = TRUE
)

normalize(
  nm,
  return = c("hospital_short_name", "hospital_full_name", "hospital_id",
    "hospital_acronym"),
  unmatched_as_na = TRUE
)
}
\arguments{
\item{nm}{A character vector of hospital names.}

\item{return}{A string indicating the hospital attribute to be returned:
either \code{hospital_short_name} (default), \code{hospital_full_name}, \code{hospital_id}
or \code{hospital_acronym}. These hospital variables are documented in
\code{\link[hospitals]{hospitals}}.}

\item{unmatched_as_na}{A logical indicating whether unmatched hospital names
are returned as \code{NA} (\code{TRUE}, the default) or as originally supplied in
\code{nm} (\code{FALSE}).}
}
\value{
A character vector.
}
\description{
\code{normalise} tries to match provided hospital names to the Portuguese NHS
hospitals, i.e. to those hospitals included in the data set
\code{\link[hospitals]{hospitals}}, thus allowing conversion to standard
hospital names. By default, it returns the shortened version of the hospital
name: column \code{hospital_short_name} in \code{\link[hospitals]{hospitals}}. Use
the \code{return} argument to return a different variable, see below for possible
values.
}
\details{
The method behind \code{normalise} for matching hospital names is based on an
heuristic that uses a minimal set of keywords to identify the hospital. This
is implemented by using regular expressions. The regular expressions are
provided in data set \code{\link[hospitals]{hospitals}}, column
\code{hospital_regex}. Moreover, the method is case insensitive and is pretty
tolerant to variations in the name as long as one of the critical keywords is
found in the name. Note however that the regular expressions have been
designed such that matches are mutually exclusive. So the same hospital name
will never match more than one hospital of the data set
\code{\link[hospitals]{hospitals}}.

\code{normalise} is aware of deprecated hospital names, and will map those old
designations to the new hospital names, e.g., Hospital do Alto Ave is
correctly mapped to Hospital da Senhora da Oliveira, Guimarães, EPE.

\code{normalise} is lenient with typos associated with accented characters, so,
e.g., both expressions 'Hospital de São João' and 'Hospital de Sao Joao' will
correctly match to the same hospital: CHU de São João.
}
\examples{
# Match hospital with a single keyword
normalise('Matosinhos')

# The same, but return now the full name
normalise('Matosinhos', 'hospital_full_name')

# Get instead the hospital identifier
normalise('Matosinhos', 'hospital_id')

# Or even just the acronym (useful for labelling in plots)
normalise('Matosinhos', 'hospital_acronym')

# Find hospitals from their old names
# "Hospital do Alto Ave" is the old name for 'Hospital da Senhora da Oliveira, Guimarães, EPE'
normalise('Hospital do Alto Ave', 'hospital_full_name')

# `normalise()` is vectorised over `nm`
normalise(nm = c('medio tejo', 'oeste', 'guarda'))

}
