% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{paths}
\alias{paths}
\title{Generate \code{assign} and \code{w.assign}.}
\usage{
paths(map, var, w = NULL)
}
\arguments{
\item{map}{Matrix of \code{n.edges}-by-\code{2} dimension, where \code{n.edges}
is the number of directed edges in DAG. The first column has indices of
nodes that edges directing from, whereas the second column gives the indices
of nodes the corresponding edges directing towards. If a node indexed \code{i}
does not have edges linked to it, record the corresponding row as
\code{map[i, NA]}.}

\item{var}{Length-\code{n.nodes} list where \code{n.nodes} is the number
of nodes in DAG and for which the \code{l}th element contains
the indices of variables embedded in the \code{l}th node.}

\item{w}{Length-\code{n.nodes} vector of positive values for which
\code{w_l} gives the weight for \code{g_l}, where \code{n.nodes} is the number
of nodes in DAG. If this is \code{NULL}, \code{w_l = sqrt(|g_l|)} will be used.
Necessary condition is \code{w_l} increases with \code{|g_l|}.}
}
\value{
Returns \code{assign}, a matrix of \code{p} columns that gives the
assignments of variables over selected path graphs, and \code{w.assign}, a
list of the same length as the number of rows in \code{assign}.
\item{assign}{Each row of \code{assign} corresponds to a path graph decomposed from DAG.}
\item{w.assign}{The \code{l}th element of the list contains the
weights corresponding to the \code{l}th row of \code{assign}
(the \code{l}th path graph).}
}
\description{
For every root node in DAG defined by \code{map}, \code{\link{paths}} circles
over all possible path graphs, picks up the one that consists of the
most unmarked node, and then marks the nodes in the path graph that have been
selected. \code{\link{paths}} won't move to the next root node, until all
the descendant nodes of the current root have been marked.
}
\examples{
# The following example appears in Figure 7 of Yan & Bien (2015).
# Generate map defining DAG.
map <- matrix(0, ncol=2, nrow=8)
map[1, ] <- c(1, 2)
map[2, ] <- c(2, 7)
map[3, ] <- c(3, 4)
map[4, ] <- c(4, 6)
map[5, ] <- c(6, 7)
map[6, ] <- c(6, 8)
map[7, ] <- c(3, 5)
map[8, ] <- c(5, 6)
# Assume two parameters per node.
var <- as.list(data.frame(t(matrix(1:16, ncol=2, byrow=TRUE))))
paths.result <- paths(map, var)
paths.result$assign
paths.result$w.assign
}
