% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/12_hm_melt.R
\name{hm_melt}
\alias{hm_melt}
\alias{hm_melt,hydromet_compact-method}
\title{Melt many objects into an \code{hydromet_compact} class object}
\usage{
hm_melt(obj, melt, slot_name, col_name, out_name = NULL)

\S4method{hm_melt}{hydromet_compact}(obj, melt, slot_name, col_name, out_name = NULL)
}
\arguments{
\item{obj}{a valid \code{hydromet_compact} class object.}

\item{melt}{string vector containing the  \code{hydromet_xxx} class objects names (as you
have in the \bold{Global Environment}) that you want for melting.}

\item{slot_name}{list (one element per \code{melt} vector name) with the slot(s) to
extract per every \code{hydromet_xxx} class object (as string vectors).}

\item{col_name}{string vector with the name of the variables to keep. You must comply
the following name convention \code{'melt_slot_variable'} (e.g.: 'guido_qd_Q(m3/s)' - where
\bold{guido} is your object name, \bold{qd} is the slot with daily mean river discharge
 and \bold{Q(m3/s)} is the required column name inside that slot). Another option is to set
 this argument just with the string \code{'all'} and the method will preserve \bold{all}
 the slot(s) columns. Other minimal option is to choose the string \code{'last'}: in this
 case you will get only the \bold{last} column of each slot(s).}

\item{out_name}{optional. String vector with the output names of the final table. If you
use the default value (\code{NULL}) the method will add the object and slot name
(provided in \code{melt} and \code{slot_name} argument) at the beginning of every column
(e.g.: \code{'guido_qd_q(m3/s)'}).}
}
\value{
An \code{hydromet_compact} class object with a data frame inside the \code{compact}
slot with all variables that you provided in \code{col_name}.
}
\description{
This method allows you merge several tables (inside \code{hydromet_station} and/or
\code{hydromet_compact} class objects) into a single one and set them into the compact slot
(\code{hydromet_compact} class object).
}
\section{Functions}{
\itemize{
\item \code{hm_melt,hydromet_compact-method}: plot method for compact class
}}

\note{
Remember that all the chosen variables should have the same temporal resolution.
The method itself will not warn you about bad entries.
}
\examples{

# lets say that we want to put together snow water equivalent from Toscas (dgi)
# and daily streamflow discharge from Guido (snih)

# path to all example files
path <- system.file('extdata', package = 'hydrotoolbox')

# on the first place we build the stations
# dgi file
toscas <-
hm_create() \%>\%
  hm_build(bureau = 'dgi', path = path,
           file_name = 'dgi_toscas.xlsx',
           slot_name = c('swe', 'tmax',
           'tmin', 'tmean', 'rh', 'patm'),
           by = 'day',
           out_name = c('swe', 'tmax',
           'tmin', 'tmean', 'rh', 'patm') )

# snih file
guido <-
hm_create() \%>\%
  hm_build(bureau = 'snih', path = path,
           file_name = c('snih_hq_guido.xlsx',
           'snih_qd_guido.xlsx'),
           slot_name = c('hq', 'qd'),
           by = c('none', 'day') )

# now we melt the requiered data
hm_create(class_name = 'compact') \%>\%
     hm_melt(melt = c('toscas', 'guido'),
             slot_name = list(toscas = 'swe', guido = 'qd'),
             col_name = 'all',
             out_name = c('swe(mm)', 'qd(m3/s)')
             ) \%>\%
       hm_plot(slot_name = 'compact',
               col_name = list( c('swe(mm)', 'qd(m3/s)') ),
               interactive = TRUE,
               line_color = c('dodgerblue', 'red'),
               y_lab = c('q(m3/s)', 'swe(mm)'),
               dual_yaxis = c('right', 'left')
                )



}
