% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_seeds.R
\name{check_seeds}
\alias{check_seeds}
\title{Standardize seeds input data type}
\usage{
check_seeds(seeds, nv, logical = FALSE)
}
\arguments{
\item{seeds}{A vector of integers or logicals, a matrix or a data frame. Input in the form of a
vector of integers denotes the indices of seeds which are identical in both graphs. Input in the
form of a vector of logicals indicate the location of seeds with TRUE and the indices of seeds
are identical in both graphs. Input in the form of a matrix or a data frame, with the first
column being the indices of \eqn{G_1} and the second
column being the corresponding indices of \eqn{G_2}.}

\item{nv}{An integer. Number of total vertices.}

\item{logical}{A logical. TRUE indicates to return seeds in a vector of logicals where TRUE
indicates the corresponding vertex is a seed. FALSE indicates to return a data frame.}
}
\value{
returns a data frame with the first column being the corresponding indices of
\eqn{G_1} and the second column being the corresponding indices of \eqn{G_2} or a vector of
logicals where TRUE indicates the corresponding vertex is a seed.
}
\description{
Convert the input seeds data into data frame type with the first column being the
indices of \eqn{G_1} and the second column being the corresponding indices of \eqn{G_2}
}
\examples{
#input is a vector of logicals
check_seeds(1:10 <= 3, nv = 10)

#input is a vector of integers
check_seeds(c(1,4,2,7,3), nv = 10)

#input is a matrix
check_seeds(matrix(1:4,2), nv = 10)

#input is a data frame
check_seeds(as.data.frame(matrix(1:4,2)), nv = 10)

}
