% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{liquor_sales}
\alias{liquor_sales}
\title{Iowa Class E Liquor Sales Summary}
\format{
a data frame with 10 variables.
\describe{
\item{year}{The year in which the sale occurred.}
\item{year_month}{This is an aggregated value indicating the month and year in YYYY-MM-DD format.}
\item{county}{The county in which the sale occurred.}
\item{population}{The population of the county of the year of sale as recorded by the US Census Bureau. NA values indicate no census data were found on the Iowa Data Portal.}
\item{type}{A high level grouping of the liquor. This was derived separately.}
\item{category}{A grouping variable used by the State of Iowa.}
\item{state_cost}{The cost (in US$) to the state to purchase the liquor from a vendor. Not adjusted for inflation.}
\item{state_revenue}{The revenue (in US$) the state earned from the sale of the liquor to retailers. Not adjusted for inflation.}
\item{bottles_sold}{The number of bottles sold by the state to a retailer.}
\item{volume}{The volume sold (in liters) by the state to a retailer.}
}
}
\source{
State of Iowa Data API \href{https://data.iowa.gov/resource/m3tr-qhgy.csv}{website}
}
\usage{
liquor_sales
}
\description{
Monthly summary of the different Class E liquor sales in State of Iowa
}
\details{
This dataset contains an aggregated view (aggregated by multiple attributes) of the sales data for Class E liquor. The dataset has been pre-processed to remove NULL values from the county and county number variables. See vignette for more details
}
\keyword{datasets}
\keyword{liquor}
\keyword{revenue}
\keyword{timeseries}
