% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-localLotkaVolterra.R
\name{localLotkaVolterra}
\alias{localLotkaVolterra}
\title{Lotka-Volterra with local predation interactions}
\usage{
localLotkaVolterra(par, T, replicates = 1, dim = 1, periodic = TRUE,
  spatial = FALSE, verbose = FALSE, maxpop = 1e+06)
}
\arguments{
\item{par}{A list containing the parameters to run the model, currently
the growth rate of prey (r), the mortality rate of predator (l), predation
interaction parameters (alpha and beta), diffusion rates (D), diameters of 
local interaction (L) and initial population size (initial). For D, L and
initial population, a list with two values (named N and P) is required.}

\item{T}{Time horizon, number of time steps to be simulated.}

\item{replicates}{Number of replicates (trajectories) to be simulated.}

\item{dim}{Spatial dimension for the space. Can be 1, 2 or 3.}

\item{periodic}{Spatial boundary conditions. If \code{periodic} is set to 
\code{TRUE}, the space is a torus. If set to \code{FALSE}, the boundaries 
are reflective.}

\item{spatial}{Boolean, should spatial outputs (position of individuals) to 
be saved?}

\item{verbose}{Boolean, to print population sizes by step?}

\item{maxpop}{Maximum population size. If predator or prey population size
get bigger, the simulation ends.}
}
\value{
A list with the following elements:
\item{N}{A matrix with prey population sizes by time (rows) and replicates (columns)}
\item{P}{A matrix with predator population sizes by time (rows) and replicates (columns)} 
\item{pop}{Prey and predator positions by time, if \code{spatial} is \code{TRUE}}
}
\description{
This function simulates several trajectories for a 
Lotka-Volterra model with local predation interactions as decribed
in Brigatti et al. (2009).
}
\examples{
\dontrun{
set.seed(880820)
par = list(alpha=5e-4, beta=5e-4, r=0.1, m=0.05, D=list(N=8e-5, P=8e-5), 
L=list(N=0.2, P=0.2))
N0 = with(par, m/(2*beta*L$P))
P0 = with(par, r/(2*alpha*L$N))
par$initial = list(N=round(N0), P=round(P0))
sim = localLotkaVolterra(par, T=240, replicates=100, maxpop = 1e4)
plot(sim)
} 
}
\author{
Ricardo Oliveros--Ramos
}
\references{
Brigatti et al. 2009.
}
\keyword{Lotka-volterra}
\keyword{interactions}
\keyword{local}

