% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importance_sampling.R
\name{ImpsampMNL}
\alias{ImpsampMNL}
\title{Importance sampling MNL}
\usage{
ImpsampMNL(
  n.draws,
  prior.mean,
  prior.covar,
  des,
  n.alts,
  y,
  alt.cte = NULL,
  lower = NULL,
  upper = NULL
)
}
\arguments{
\item{n.draws}{Numeric value indicating the number of draws.}

\item{prior.mean}{Numeric vector indicating the mean of the multivariate
normal distribution (prior).}

\item{prior.covar}{Covariance matrix of the prior distribution.}

\item{des}{A design matrix in which each row is a profile. If alternative
specific constants are present, those should be included as the first
column(s) of the design. Can be generated with \code{\link{Modfed}} or \code{\link{CEA}}.}

\item{n.alts}{Numeric value indicating the number of alternatives per choice
set.}

\item{y}{A binary response vector. \code{\link{RespondMNL}} can be used to
simulate response data.}

\item{alt.cte}{A binary vector indicating for each alternative whether an
alternative specific constant is desired. The default is \code{NULL}.}

\item{lower}{Numeric vector of lower truncation points, the default
is \code{NULL}.}

\item{upper}{Numeric vector of upper truncation points, the default
is \code{NULL}.}
}
\value{
\item{sample}{Numeric vector with the (unweigthted) draws from the
posterior distribution.} \item{weights}{Numeric vector with the associated
weights of the draws.} \item{max}{Numeric vector with the estimated
mode of the posterior distribution.} \item{covar}{Matrix representing the
estimated variance covariance matrix.}
}
\description{
This function samples from the posterior distribution using importance
sampling, assuming a multivariate (truncated) normal prior distribution and a
MNL likelihood.
}
\details{
For the proposal distribution a t-distribution with degrees of freedom equal
to the number of parameters is used. The posterior mode is estimated using
\code{\link[stats]{optim}}, and the covariance matrix is calculated as the negative
inverse of the generalized Fisher information matrix. See reference for more
information.

From this distribution a lattice grid of draws is generated.

If truncation is present, incorrect draws are rejected and new ones are
generated untill \code{n.draws} is reached. The covariance matrix is in this case
still calculated as if no truncation was present.
}
\examples{
## Example 1: sample from posterior, no constraints, no alternative specific constants 
# choice design  
design <- example_design
# Respons.
truePar <- c(0.7, 0.6, 0.5, -0.5, -0.7, 1.7) # some values
set.seed(123)
resp <- RespondMNL(par = truePar, des = design, n.alts = 2)
#prior
pm <- c(1, 1, 1, -1, -1, 1) # mean vector 
pc <- diag(1, ncol(design)) # covariance matrix 
# draws from posterior.
ImpsampMNL(n.draws = 100, prior.mean =  pm, prior.covar = pc,
           des = design, n.alts = 2, y = resp)

## example 2:  sample from posterior with constraints 
# and alternative specific constants
# choice design. 
design <- example_design2
# Respons.
truePar <- c(0.2, 0.8, 0.7, 0.6, 0.5, -0.5, -0.7, 1.7) # some values
set.seed(123)
resp <- RespondMNL(par = truePar, des = design, n.alts = 3)
# prior
pm <- c(1, 1, 1, 1, 1, -1, -1, 1) # mean vector 
pc <- diag(1, ncol(design)) # covariance matrix
low = c(-Inf, -Inf, 0, 0, 0, -Inf, -Inf, 0)
up = c(Inf, Inf, Inf, Inf, Inf, 0, 0, Inf)
# draws from posterior.
ImpsampMNL(n.draws = 100, prior.mean =  pm, prior.covar = pc, des = design,
           n.alts = 3, y = resp, lower = low, upper = up, alt.cte = c(1, 1, 0))
}
\references{
\insertRef{ju}{idefix}
}
