% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citrusSize.R
\name{citrusSize}
\alias{citrusSize}
\alias{citrusMarkPos}
\alias{markOverCMA}
\title{FUNCTIONS: citrusSize, citrusMarkPos, markOverCMA}
\usage{
citrusSize(
  A = 0,
  B = 0,
  C = 0,
  D = 0,
  E = 0,
  F = 0,
  FL = 0,
  FL0 = 0,
  G = 0,
  shortArm = 1.2,
  longArm = 1.7,
  shortArmFL = 1.3,
  longArmFL = 1.8,
  OTU = "OTU 1"
)

citrusMarkPos(
  chrSizeDf,
  mSizePter = 0.25,
  mSizeQter = 0.35,
  mSizePprox = 0.35,
  mOther = 0.25,
  markName = "CMA"
)

markOverCMA(
  citrusMarkPosDF,
  chrType = "B",
  chrName,
  chrRegion = "p",
  markName = "45S",
  shrinkMark = TRUE
)
}
\arguments{
\item{A}{number of A to calculate (citrusSize)}

\item{B}{number of B to calculate (citrusSize)}

\item{C}{number of C to calculate (citrusSize)}

\item{D}{number of D to calculate (citrusSize)}

\item{E}{number of E to calculate (citrusSize)}

\item{F}{number of F to calculate (citrusSize)}

\item{FL}{number of FL+ to calculate (citrusSize)}

\item{FL0}{number of FL0 to calculate (citrusSize)}

\item{G}{number of G to calculate (citrusSize)}

\item{shortArm}{for A to G (not FL) (citrusSize)}

\item{longArm}{for A to G (not FL) (citrusSize)}

\item{shortArmFL}{for FL (citrusSize)}

\item{longArmFL}{for FL (citrusSize)}

\item{OTU}{name of species (citrusSize)}

\item{chrSizeDf}{data.frame created with \code{citrusSize} function (citrusMarkPos)}

\item{mSizePter}{numeric, default size for P(short) ter (terminal) bands. \code{0.25} (default) (citrusMarkPos)}

\item{mSizeQter}{numeric, default size for Q(long) ter (terminal) bands. \code{0.35} (default) (citrusMarkPos)}

\item{mSizePprox}{numeric, default size for P prox (proximal) bands. \code{0.35} (default) (citrusMarkPos)}

\item{mOther}{numeric, default size for other bands. \code{0.25} (default) (citrusMarkPos)}

\item{markName}{character, default name of mark \code{"CMA"}, or \code{"45S"}, respectively. (citrusMarkPos,markOverCMA)}

\item{citrusMarkPosDF}{data.frame, with CMA marks (markOverCMA)}

\item{chrType}{character, defaults to "B", chr. type to duplicate mark (markOverCMA)}

\item{chrName}{character, defaults to "B", chr. name(s) to duplicate mark (markOverCMA)}

\item{chrRegion}{character, arm, defaults to "p". for mark duplication (markOverCMA)}

\item{shrinkMark}{boolean, shrink new mark to be created (markOverCMA)}
}
\value{
data.frame

data.frame

data.frame
}
\description{
Helper function to create data.frames with
chr. size and mark size data for Citrus
based on categories in Carvalho et al. (2005)

Special behaviour while plotting:
normally you will get chr. names as: B_1, B_2, etc.
to remove _*, use \code{chrIdPatternRem='_.*'} in
\code{plotIdiograms}. However, for FL+ and FL0,
this conversion is automatic. So, in plot you will
never see FL0_1, FL0_2, for example.
}
\examples{
citrusSizeDF <- citrusSize(B=1,D=11,F=4,FL0=2,OTU="C. jambhiri")
suppressMessages(
plotIdiograms(citrusSizeDF,
              indexIdTextSize=.4,# font size
              rulerNumberSize=.4,# font size
              rulerTitleSize=.4, # font size
              rulerPos =-.5,     # ruler pos.
              xPosRulerTitle =1.5,     # ruler title pos.
              orderChr="original"# order of chr. as in d.f.
              )
              )
citrusSizeDF2 <- citrusSize(B=2,D=10,F=4,FL0=1,
FL=1,         # equivalent to FL+
OTU="C. limettioides")


suppressMessages(
 plotIdiograms(citrusSizeDF2,     # FL^NA error corrected in 1.15.4
               indexIdTextSize=.4,# font size
               rulerNumberSize=.4,# font size
               rulerTitleSize=.4, # font size
               rulerPos =-.5,     # ruler pos.
               xPosRulerTitle =1.5,     # ruler title pos.
               orderChr="original"# order of chr. as in d.f.
 )
)

citrusMarkPosDF <- citrusMarkPos(citrusSizeDF)
suppressMessages(
plotIdiograms(dfChrSize= citrusSizeDF,      # chr. size data.frame
              dfMarkPos= citrusMarkPosDF,# mark position data.frame (inc. cen.)
              ruler=FALSE,               # remove
              chrIndex=FALSE,            # remove
              morpho=FALSE,              # remove
              karIndex=FALSE,            # remove
              indexIdTextSize=.4,        # font size
              xlimRightMod=4,            # xlim mod.
              orderChr="original",       # order chr. as in d.f.
              chrColor="blue",           # chr. color
              legendHeight=3             # legend item height
              )
              )
citrusMarkPosDF45S<-markOverCMA(citrusMarkPosDF, chrType="B", chrRegion="p", markName="45S")
suppressMessages(
plotIdiograms(dfChrSize= citrusSizeDF, # chr. size data.frame
              dfMarkPos= citrusMarkPosDF45S,# mark position data.frame (inc. cen.)
              ruler=FALSE,             # remove ruler
              chrIndex=FALSE,          # remove index
              morpho=FALSE,            # remove morphol.
              karIndex=FALSE,          # remove
              indexIdTextSize=.4,      # font size chr.
              xlimRightMod=4,          # modify xlim
              orderChr="original",     # as in d.f.
              chrColor="blue",
              legendHeight=5,          # height of legend item
              colorBorderMark="black", # mark border color
              OTUfont=3                # italics
              )
              )
}
\references{
Carvalho, R., Soares Filho, W. S., Brasileiro-Vidal, A. C., & Guerra, M. (2005). The relationships among lemons, limes and citron: A chromosomal comparison. Cytogenetic and Genome Research, 109(1–3), 276–282. https://doi.org/10.1159/000082410
}
\keyword{arm}
\keyword{size}
