#' The War Prayer
#'
#' A dataset which contains one short story written by Mark Twain that
#' expresses his outrage at US military intervention in the Philippines. "It is
#' a scathing indictment of war, and particularly of blind patriotic and
#' religious fervor as motivations for war. The structure of the work is
#' simple: An unnamed country goes to war, and patriotic citizens attend a
#' church service for soldiers who have been called up. The people call upon
#' their God to grant them victory and protect their troops. Suddenly, an "aged
#' stranger" appears and announces that he is God's messenger. He explains to
#' them that he is there to speak aloud the second part of their prayer for
#' victory, the part which they have implicitly wished for but have not spoken
#' aloud themselves: the prayer for the suffering and destruction of their
#' enemies. What follows is a grisly depiction of hardships inflicted on
#' war-torn nations by their conquerors. The story ends with the man being
#' ignored." (Source: The War Prayer [Wikipedia])
#'
#' @format A VCorpus of 1 text document.
#'
#'
#' @references
#' \enumerate{
#'    \item Mark Twain, "The War Prayer", \emph{The Complete Works of Mark Twain: Europe and Elsewhere, Vol. 20}, New York City, New York: Harper and Brothers, 1923, page 394-399. See \url{https://archive.org/details/completeworksofm20twai} and \url{http://www.twainquotes.com/UniformEds/UniformEdsCh34.html}.
#'    \item Wikimedia Foundation, Inc. Wikipedia, 28 July 2016, “The War Prayer”, See \url{https://en.wikipedia.org/wiki/The_War_Prayer} and \url{http://warprayer.org/}.
#'    \item Wikimedia Foundation, Inc. Wikisource, 26 October 2014, “The War Prayer”, \url{https://en.wikisource.org/wiki/The_War_Prayer}.
#' }
#'
#'
#' @docType data
#' @name war_prayer
#' @usage war_prayer
#' @examples
#' data(war_prayer)
#' war_prayer
NULL
