% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterative_triclass_thresholding.R
\name{ThresholdTriclass}
\alias{ThresholdTriclass}
\title{Iterative Triclass Thresholding}
\usage{
ThresholdTriclass(im, stopval = 0.01, repeatnum, intervalnumber = 1000,
  returnvalue = FALSE)
}
\arguments{
\item{im}{a grayscale image of class cimg}

\item{stopval}{value to determine whether stop iteration of triclass thresholding or not. Note that if repeat is set, stop is ignored.}

\item{repeatnum}{number of repetition of triclass thresholding}

\item{intervalnumber}{interval number  of histogram}

\item{returnvalue}{if returnvalue is TRUE, ThresholdTriclass returns threshold value. if FALSE, ThresholdTriclass returns pixset.}
}
\value{
a pixel set or a numeric
}
\description{
compute threshold value by Iterative Triclass Threshold Technique
}
\examples{
g <- grayscale(boats)
layout(matrix(1:4, 2, 2))
plot(boats, main = "Original")
plot(g, main = "Grayscale")
threshold(g) \%>\% plot(main = "A Variant of Otsu")
ThresholdTriclass(g) \%>\% plot(main = "Triclass")
}
\references{
Cai HM, Yang Z, Cao XH, Xia WM, Xu XY (2014). A New Iterative Triclass Thresholding Technique in Image Segmentation. IEEE TRANSACTIONS ON IMAGE PROCESSING.
}
\author{
Shota Ochi
}
