% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v3_denue.R
\name{inegi_denue_stats}
\alias{inegi_denue_stats}
\title{Returns statistics of coordinate}
\usage{
inegi_denue_stats(latitud_vector, longitud_vector, token, meters = 250,
  keyword = "todos")
}
\arguments{
\item{latitud_vector}{number of column in data with latitud column}

\item{longitud_vector}{number of column in data with longitud column}

\item{token}{API token supplied by INEGI}

\item{meters}{Distance in meters to search by coordinate}

\item{keyword}{Keyword of businesses to include. Defaults to all ("todos")}
}
\value{
Data.frame
}
\description{
Returns basic statistics of businesses, using DENUE, in the vecinity of coordinates.
}
\details{
Some columns, like employee numbers are experimental (the employees are added considering size of company).
}
\examples{
\dontrun{
token<-"webservice_token"
df <- as.data.frame(latitud  = c(25.669194, 25.121194),
                  longitud = c(-100.30990, -99.81923))
stats <- denue_varios_stats(data     = df,
                          col_lat  = 1,
                          col_long = 2,
                          metros   = 500)
}
}
\author{
Eduardo Flores
}
