% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two.sample.mean.R
\name{two.sample.mean}
\alias{two.sample.mean}
\title{Range-Preserving Two-Sample T-Test for Equality of Means}
\usage{
two.sample.mean(x, y, transformation = c("none", "log", "logit"),
  alternative = c("two.sided", "less", "greater"), paired = FALSE,
  alpha = 0.05, plot.ci = TRUE, plot.ici = TRUE,
  ici.interval = NULL, add.individual.ci = TRUE, by.ici = 0.5,
  xlab.ici = "", rounds = 3, rounds.plot = NULL,
  ci.interval = NULL, by.ci = 0.5, name.x = NULL, name.y = NULL,
  pool.mean = FALSE, logit.interval = NULL, rho = NULL,
  tol = 1e-07)
}
\arguments{
\item{x}{A vector specifying the first sample.}

\item{y}{A vector specifying the second sample.}

\item{transformation}{A character string specifying the transformation on the sample means; "none" for real-valued data, "log" for positive-valued data, and "logit" for data in a fixed interval. The default option is "none".}

\item{alternative}{A character string specifying the alternative hypothesis; "two.sided" for two-tailed, "less" for left-tailed, and "greater" for right-tailed alternative hypothesis. The default option is "two.sided".}

\item{paired}{A boolean specifying whether or not the samples are paired or independent. The default option is FALSE.}

\item{alpha}{A numeric specifying the significance level. The default option is 0.05.}

\item{plot.ci}{A boolean specifying whether or not the deviation between the two samples should be plotted. The default option is TRUE.}

\item{plot.ici}{A boolean specifying whether or not the inferential confidence intervals for the two samples should be plotted. The default option is TRUE.}

\item{ici.interval}{A vector with two elements specifying the range of values for the plot of inferential confidence intervals. The default option is NULL, in which case, an appropriate range is automatically specified.}

\item{add.individual.ci}{A boolean specifying whether or not the confidence intervals with the confidence level implied by \code{alpha} should also be plotted. The default option is TRUE.}

\item{by.ici}{A numeric specifying te scales in the plot for ici.interval. The default option is 0.5.}

\item{xlab.ici}{A character string specifying the x axis labels used for the inferential confidence intervals and confidence intervals. The default option is "".}

\item{rounds}{A numeric specifying the number of decimal places to be rounded. The default option is 3.}

\item{rounds.plot}{A numeric specifying the number of decimal places to be rounded. The default option is NULL, in which case it is set equal to \code{rounds}.}

\item{ci.interval}{A vector with two elements specifying the range of values for the plot of confidence intervals. The default option is NULL, in which case, an appropriate range is automatically specified.}

\item{by.ci}{A numeric specifying te scales in the plot for ci.interval. The default option is 0.5.}

\item{name.x}{A character string specifying the label for the x variable. The default option is NULL, in which case, it is set to "x".}

\item{name.y}{A character string specifying the label for the y variable. The default option is NULL, in which case, it is set to "y".}

\item{pool.mean}{A boolean specifying whether or not the sample means should be pooled for the degrees of freedom. The default option is FALSE.}

\item{logit.interval}{A vector with two elements specifying the lower and upper bound if logit transformation is used. The default option is NULL.}

\item{rho}{A numeric specifying the correlation coefficient between the two samples. The default option is NULL, in which case, the sample correlation coefficient is estimated automatically.}

\item{tol}{A numeric specifying the cut-off value for a numerical zero. The default option is 1e-7.}
}
\value{
\item{CI}{A data frame displaying the effect size estimate, lower and upper bound of the effect size confidence interval, and the degrees of freedom.}
\item{ICI}{A data frame displaying the sample mean for both x and y, lower and upper bounds of the inferential confidence intervals, the degrees of freedom of the inferential confidence intervals, the inferential significance level, and the significance level.}
\item{Statistic}{A data frame displaying the test statistic and p-value of the generalized two-sample t-test.}
\item{Ind.CI}{A data frame displaying the sample mean for both x and y, lower and upper bounds of the individual confidence intervals, the degrees of freedom of the individual confidence intervals, the sample standard deviations, and the significance level.}
\item{Effect.Sizes}{A data frame displaying Cohen's d and either log ratio (for transformation="log") or log odds (for transformation="logit").}
}
\description{
Range-preserving two-sample t-test for comparing means.
}
\examples{
 set.seed(123)
 x<-runif(10)
 y<-runif(15)
 two.sample.mean(x,y,"logit","two.sided",paired=FALSE, ici.interval=c(0,1),
  by.ici=0.2, logit.interval=c(0,1), rounds=2, name.x="xvar", name.y="yvar")

}
