% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{.solveWt}
\alias{.solveWt}
\title{Correlation between weighted predictor composite and criterion.}
\usage{
.solveWt(wt_vec, rxx, rxy)
}
\arguments{
\item{wt_vec}{A vector of predictor weights.}

\item{rxx}{A matrix of predictor intercorrelations.}

\item{rxy}{A vector of predictor, criterion correlations.}
}
\value{
A correlation coefficent.
}
\description{
Correlation between weighted predictor composite and criterion.
}
\note{
This is a simpler, faster version of the formula used for fuse().
}
\examples{
library(iopsych)
data(dls2007)
dat <- dls2007[1:6, 2:7]
rxx <- dat[1:4, 1:4]
rxy <- dat[1:4, 5]

#.solveWt(wt_vec=c(1,1,1,1), rxx=rxx, rxy=rxy)
#.solveWt(wt_vec=c(1,2,3,4), rxx=rxx, rxy=rxy)
}
\author{
Allen Goebl Jeff Jones
}
\keyword{internal}

