% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc2x3.r
\name{ci.ICC2r.nointer}
\alias{ci.ICC2r.nointer}
\title{Confidence Interval of the ICC(2,1) under Model 2 without subject-rater interaction}
\usage{
ci.ICC2r.nointer(dfra, conflev = 0.95)
}
\arguments{
\item{dfra}{This is a data frame containing 3 columns or more.  The first column contains subject numbers (there could be duplicates
if a subject was assigned multiple ratings) and each of the remaining columns is associated with a particular rater and contains its
numeric ratings.}

\item{conflev}{This is the optional confidence level associated with the confidence interval. If not specified, the default value
will be 0.95, which is the most commonly-used valuee in the literature.}
}
\value{
This function returns a vector containing the lower confidence (lcb) and the upper confidence bound (ucb).
}
\description{
This function computes the confidence interval associateed with the Intraclass Correlation Coefficient (ICC) used as a measure
of inter-rater reliability, under the random factorial ANOVA model (Model 2) with no subject-rater interaction. This function computes
the lower and upper confidence bounds.
}
\examples{
#iccdata1 is a small dataset that comes with the package. Use it as follows:
library(irrICC)
iccdata1 #see what the iccdata1 dataset looks like
ci.ICC2r.nointer(iccdata1)
}
\references{
Gwet, K.L. (2014): \emph{Handbook of Inter-Rater Reliability - 4th ed.} chapter 9, section 9.5.1, equations
9.5.7 and 9.5.8 for inter-rater reliability coefficients.
Advanced Analytics, LLC.
}
