% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icc1factor.r
\name{icc1a.fn}
\alias{icc1a.fn}
\title{Intraclass Correlation Coefficient (ICC) under ANOVA Model 1A.}
\usage{
icc1a.fn(ratings)
}
\arguments{
\item{ratings}{This is a data frame containing 3 columns or more.  The first column contains subject numbers (there could be duplicates
if a subject was assigned multiple ratings) and each of the remaining columns is associated with a particular rater and contains its
numeric ratings.}
}
\value{
This function returns a list containing the following 9 values:
1. sig2s: the subject variance component. 2. sig2e: the error variance component. 3. icc1a: the ICC/inter-rater reliability coefficient
4. n: the number of subjects. 5. r: the number of raters. 6. max.rep: the maximum number of ratings per subject. 7. min.rep: the minimum
number of ratings per subjects. 8. M: the total number of ratings for all subjects and raters. 9. ov.mean: the overall mean rating.
}
\description{
This ICC is associated with the one-factor ANOVA model where each subject could be rated by a different group of raters. This ICC represents
a measure of inter-rater reliability among all raters involved in the experiment.
}
\examples{
#iccdata1 is a small dataset that comes with the package. Use it as follows:
library(irrICC)
iccdata1 #see what the iccdata1 dataset looks like
icc1a.fn(iccdata1)
coeff <- icc1a.fn(iccdata1)$icc1a
coeff
}
\references{
Gwet, K.L. (2014): \emph{Handbook of Inter-Rater Reliability - 4th ed.} - Equation #8.1.3, chapter 8. Advanced Analytics, LLC.
}
