% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglike_score.R
\name{llike_score}
\alias{llike_score}
\title{Loglikelihood of ability}
\usage{
llike_score(
  x,
  data,
  theta,
  D = 1,
  method = "MLE",
  norm.prior = c(0, 1),
  fence.a = 3,
  fence.b = NULL,
  missing = NA
)
}
\arguments{
\item{x}{A data frame containing the item metadata (e.g., item parameters, number of categories, models ...).
See \code{\link{irtfit}}, \code{\link{test.info}}, or \code{\link{simdat}} for more details about the item metadata.
This data frame can be easily obtained using the function \code{\link{shape_df}}.}

\item{data}{A matrix or vector containing examinees' response data for the items in the argument \code{x}. When a matrix is used, a row and column indicate
the examinees and items, respectively. When a vector is used, it should contains the item response data for an examinee.}

\item{theta}{A numeric vector of abilities of which loglikelihood values are computed.}

\item{D}{A scaling factor in IRT models to make the logistic function as close as possible to the normal ogive function (if set to 1.7).
Default is 1.}

\item{method}{A character string indicating a scoring method. Available methods are "MLE" for the maximum likelihood estimation,
"MLEF" for the maximum likelihood estimation with fences, "MAP" for the maximum a posteriori estimation. Default method is "MLE".}

\item{norm.prior}{A numeric vector of two components specifying a mean and standard deviation of the normal prior distribution.
These two parameters are used to obtain the gaussian quadrature points and the corresponding weights from the normal distribution. Default is
c(0,1). Ignored if \code{method} is "MLE" or "MLEF".}

\item{fence.a}{A numeric value specifying the item slope parameter (i.e., \emph{a}-parameter) for the two imaginary items in MLEF. See below for details.
Default is 3.0.}

\item{fence.b}{A numeric vector of two components specifying the lower and upper fences of item difficulty parameters (i.e., \emph{b}-parameters)
for the two imaginary items, respectively, in MLEF. When \code{fence.b = NULL}, the lower and upper fences of item difficulty parameters were
automatically set. See below for details. Default is NULL.}

\item{missing}{A value indicating missing values in the response data set. Default is NA.}
}
\value{
A data frame of loglikelihood values. A row indicates the ability value where the loglikelihood is computed and
a column represents a response pattern, respectively.
}
\description{
This function computes the loglikelihood of abilities for examinees given the item parameters and response data.
}
\details{
The loglikelihood function of ability for an examinee can be computed given the item parameters and the examinee's response data for the items.
For example, if you want to examine the loglikelihood functions of abilities for two examinees given the same test items specified in the argument \code{x},
then you should provide the item response data matrix with two rows in the argument \code{data} and a vector of ability points where the loglikelihood values
need to be computed in the argument \code{theta}. Or if you want to examine the loglikelihood function of ability for an examinee given the test items
specified in the argument \code{x}, then you should provide the item response data matrix with one row (or a vector of item response data) in the argument
\code{data} and a vector of ability points where the loglikelihood values need to be computed in the argument \code{theta}.
}
\examples{
## import the "-prm.txt" output file from flexMIRT
flex_sam <- system.file("extdata", "flexmirt_sample-prm.txt", package = "irtplay")

# read item parameters and transform them to item metadata
x <- bring.flexmirt(file=flex_sam, "par")$Group1$full_df

# generate examinees' abilities from N(0, 1)
set.seed(10)
score <- rnorm(5, mean=0, sd=1)

# simulate the response data
data <- simdat(x=x, theta=score, D=1)

# set the ability values where the loglikelihood values are computed
theta <- seq(-3, 3, 0.5)

# compute the loglikelihood values (When MLE method is used)
llike_score(x=x, data=data, theta=theta, D=1, method="MLE")

}
\author{
Hwanggyu Lim \email{hglim83@gmail.com}
}
