% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_traceline.R
\name{plot.traceline}
\alias{plot.traceline}
\title{Plot ICC and TCC}
\usage{
\method{plot}{traceline}(
  x,
  item.loc = NULL,
  score.curve = FALSE,
  overlap = FALSE,
  layout.col = 2,
  xlab.text,
  ylab.text,
  main.text,
  lab.size = 15,
  main.size = 15,
  axis.size = 15,
  line.color,
  line.size = 1,
  strip.size = 12,
  ...
)
}
\arguments{
\item{x}{An object of class \code{\link{traceline}}.}

\item{item.loc}{A numeric value indicating that the \emph{n}th item (or the location of item) is plotted.
If NULL, the TCC based on a total test form is drawn. Default is NULL.}

\item{score.curve}{Logical value. If TRUE, item score curve (i.e., a weighted sum of item category probabilities over the item scores) is plotted
in a panel. Otherwise, ICCs for all score categories are plotted in separate panels. For a dichotomous item, the item score curve is the same as
the ICC of score category 1. Ignored when \code{item.loc = NULL}. Default is FALSE.}

\item{overlap}{Logical value indicating whether multiple item score curves are plotted in one panel. 
If FALSE, the multiple item score curves are displayed with multiple panels, one for each.}

\item{layout.col}{An integer value indicating the number of columns in the panel when displaying ICCs for an item or 
when displaying multiple item scores with multiple panels.}

\item{xlab.text, ylab.text}{A title for the x and y axes.}

\item{main.text}{An overall title for the plot.}

\item{lab.size}{The size of xlab and ylab. Default is 15.}

\item{main.size}{The size of \code{main.text}. Default is 15.}

\item{axis.size}{The size of labels along the x and y axes. Default is 15.}

\item{line.color}{A character string specifying the color for a line. See \url{http://www.cookbook-r.com/Graphs/Colors_(ggplot2)/} for more details
about colors used in ggplot2.}

\item{line.size}{The size of lines. Default is 1.}

\item{strip.size}{The size of facet labels when ICCs for an item are plotted.}

\item{...}{Further arguments passed from the function \code{geom_line()} in the \pkg{ggplot2} package.}
}
\description{
This function plots item or test characteristic curve using the ggplot2 package. The item characteristic
(or category) curve (ICC) or item score curve is drawn for an individual item. The test characteristic curve (TCC) is drawn
based on a total test form.
}
\details{
All of the plots are drawn using the ggplot2 package.
If \code{item.loc = NULL}, the TCC based on the total test form is plotted. In the argument \code{item.loc},
a vector of positive integer values should be specified to indicate the \emph{n}th items among the total test form. For example,
if there are ten items in the test form and the score curves of the 1st, 2nd, and 3rd items should be plotted, then \code{item.loc = 1:3}.
}
\examples{
## example
## using a "-prm.txt" file obtained from a flexMIRT
# import the "-prm.txt" output file from flexMIRT
flex_prm <- system.file("extdata", "flexmirt_sample-prm.txt", package = "irtplay")

# read item parameters and transform them to item metadata
test_flex <- bring.flexmirt(file=flex_prm, "par")$Group1$full_df

# set theta values
theta <- seq(-3, 3, 0.1)

# compute the item category probabilities and item/test
# characteristic functions given the theta values
x <- traceline(x=test_flex, theta, D=1)

# plot TCC based on the total test form
plot(x, item.loc=NULL)

# plot ICCs for the first item (dichotomous item)
plot(x, item.loc=1, score.curve=FALSE, layout.col=2)

# plot item score curve for the first item (dichotomous item)
plot(x, item.loc=1, score.curve=TRUE)

# plot item score curves for the first six dichotomous items
# with multiple panels 
plot(x, item.loc=1:6, score.curve=TRUE, overlap=FALSE)

# plot item score curve for the first six dichotomous items
# in one panel
plot(x, item.loc=1:6, score.curve=TRUE, overlap=TRUE)

# plot ICCs for the last item (polytomous item)
plot(x, item.loc=55, score.curve=FALSE, layout.col=2)

# plot item score curve for the last item (polytomous item)
plot(x, item.loc=55, score.curve=TRUE)

# plot item score curves for the last three polytomous items
# with multiple panels
plot(x, item.loc=53:55, score.curve=TRUE, overlap=FALSE)

# plot item score curves for the last three poltyomous items
# in one panel
plot(x, item.loc=53:55, score.curve=TRUE, overlap=TRUE)

}
\seealso{
\code{\link{traceline}}
}
\author{
Hwanggyu Lim \email{hglim83@gmail.com}
}
