% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_den.R
\name{post_den}
\alias{post_den}
\title{Updated prior (a.k.a. posterior) latent ability distribution}
\usage{
post_den(
  x,
  data,
  D = 1,
  Quadrature = c(49, 6),
  weights = NULL,
  group.mean = 0,
  group.var = 1,
  missing = NA
)
}
\arguments{
\item{x}{A data frame containing the item metadata (e.g., item parameters, number of categories, models ...). 
See \code{\link{irtfit}}, \code{\link{test.info}}, or \code{\link{simdat}}  for more details about the item metadata.
This data frame can be easily obtained using the function \code{\link{shape_df}}.}

\item{data}{A matrix containing examinees' response data for the items in the argument \code{x}. A row and column indicate
the examinees and items, respectively.}

\item{D}{A scaling factor in IRT models to make the logistic function as close as possible to the normal ogive function (if set to 1.7).
Default is 1.}

\item{Quadrature}{A numeric vector of two components specifying the number of quadrature points (in the first component) and
the symmetric minimum and maximum values of these points (in the second component). For example, a vector of c(49, 6) indicates 49 rectangular
quadrature points over -6 and 6. Default is c(49, 6).}

\item{weights}{A two-column matrix or data frame containing the quadrature points (in the first column) and the corresponding weights
(in the second column) of the latent variable prior distribution. The weights and quadrature points can be easily obtained
using the function \code{\link{gen.weight}}. If NULL, a normal prior density is used based on the information provided in the arguments
of \code{Quadrature}, \code{group.mean}, and \code{group.var}). Default is NULL.}

\item{group.mean}{A numeric value to set the mean of latent variable prior distribution. Default is 0.}

\item{group.var}{A positive numeric value to set the variance of latent variable prior distribution. Default is 1.}

\item{missing}{A value indicating missing values in the response data set. Default is NA.}
}
\value{
This function returns a list containing two internal objects. The first internal object is a data frame with two columns, 
where the first column has theta values (nodes) and the second column provides the weights of the posterior latent ability distribution. 
The second internal object is a data frame containing the mean, variance, and standard deviation of the distribution.
}
\description{
This function computes updated prior (a.k.a. posterior) densities of the latent ability distribution given 
a prior ability distribution, item parameters, and item response data.
}
\examples{

\donttest{
# fit the 2PL model to LSAT6 data
(mod.2pl <- est_irt(data=LSAT6, D=1, model="2PLM", cats=2))

# extract the item parameter estimates
(x <- getirt(x=mod.2pl, what="par.est"))

# update the standard normal prior deisnty of the ability distribution
# using the estimated item parameters
(upd_prior <- post_den(x=x, data=LSAT6, D=1, group.mean=0, group.var=1))
}

}
\seealso{
\code{\link{shape_df}}, \code{\link{irtfit}}, \code{\link{test.info}}, \code{\link{simdat}}
}
\author{
Hwanggyu Lim \email{hglim83@gmail.com}
}
