% Generated by roxygen2 (4.0.1): do not edit by hand
\name{iroundrobin}
\alias{iroundrobin}
\title{Iterator that traverses each given iterable in a roundrobin order}
\usage{
iroundrobin(...)
}
\arguments{
\item{...}{multiple arguments to iterate through in roundrobin sequence}
}
\value{
iterator that alternates through each argument in roundrobin sequence
}
\description{
Constructs an iterator that traverses each given iterable in a roundrobin
order. That is, the iterables are traversed in an alternating fashion such
that the each element is drawn from the next iterable. If an iterable has no
more available elements, it is skipped, and the next element is taken from
the next iterable having available elements.
}
\examples{
it <- iterators::iter(c("A", "B", "C"))
it2 <- iterators::iter("D")
it3 <- iterators::iter(c("E", "F"))
as.list(iroundrobin(it, it2, it3)) # A D E B F C

it_rr <- iroundrobin(1:3, 4:5, 7:10)
as.list(it_rr) # 1 4 7 2 5 8 3 9 10
}

