% Generated by roxygen2 (4.0.1): do not edit by hand
\name{iunique}
\alias{iunique}
\title{Iterator that extracts the unique elements from an iterable object}
\usage{
iunique(object)
}
\arguments{
\item{object}{an iterable object}
}
\value{
an iterator that returns the unique elements from \code{object}
}
\description{
Constructs an iterator that extracts each unique element in turn from an
iterable \code{object}. Order of the elements is maintained. This function is
an iterator analogue to \code{\link[base]{sort}}.
}
\details{
NOTE: In order to determine whether an element is unique, a list of previous
unique elements is stored. In doing so, the list can potentially become large
if there are a large number of unique elements.
}
\examples{
it <- ichain(rep(1, 4), rep(2, 5), 4:7, 2)
as.list(iunique(it)) # 1 2 4 5 6 7

it2 <- iterators::iter(c('a', 'a', "A", "V"))
as.list(iunique(it2)) # a A V

x <- as.character(gl(5, 10))
it_unique <- iunique(x)
as.list(it_unique) # 1 2 3 4 5
}

