% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egfr.R
\name{egfr.schwartz}
\alias{egfr.schwartz}
\title{Schwartz (for children only)}
\usage{
egfr.schwartz(creatinine, age, sex, height_cm = 0, height_ft = 0,
  height_inch = 0, creatinine_units = "micromol/l",
  equation_type = "classic", label_sex_male = c("Male", 1),
  label_sex_female = c("Female", 0))
}
\arguments{
\item{creatinine}{Numeric vector. Serum creatinine, could be expressed in "micromol/L", "mmol/L" or "mg/dL". Units of measurement should be defined in variable creatinine_units (if not defined explicitly by user, the default value is "micromol/L").}

\item{age}{Numeric vector. Age, in years. Age does not accounted in Schwartz equation, but used in the function to check whether Schwartz equation could be applied to a given patient.}

\item{sex}{Vector. The value of variable refers to the parameters label_sex_male and label_sex_female. Required only in case of quadratic Schwartz equation.}

\item{height_cm}{Numeric vector. Could be defined either as height_cm if is measured in cm, or as height_ft and height_inch if is measured in feet and inches.
If the parameter height_cm is greater than 0, the function uses cm, otherwise - feet and inches.}

\item{height_ft}{see height_cm}

\item{height_inch}{see height_cm}

\item{creatinine_units}{Character string. Units in which serum creatinne is expressed. Could be one of the following: "micromol/L", "mmol/L" or "mg/dL".}

\item{equation_type}{Character string. Define whether to calculate eGFR either by classic Schwartz or quadratic Schwartz equation. Could be one of the following: "classic", "quadratic". If not explicitly defined by user, the default assumption is "classic".}

\item{label_sex_male}{List. Label(s) for definition(s) of male sex.}

\item{label_sex_female}{List. Label(s) for definition(s) of female sex.}
}
\value{
numeric eGFR expressed in ml/min/1.73m<sup>2</sup>.
}
\description{
Schwartz (for children only)
}
\details{
Calculate estimated glomerular filtration rate (eGFR) by Schwartz equation
Reference to the equation: Gao A, Cachat F, Faouzi M et al. Comparison of the glomerular filtration rate in children by the new revised Schwartz formula and a new generalized formula. Kidney International 2013;83:524–30.

Programming: Boris Bikbov \email{boris@bikbov.ru}.
Citation: Bikbov B. R open source programming code for calculation of the Kidney Donor Profile Index and Kidney Donor Risk Index. Kidney Diseases, 2018. DOI: 10.1159/000492427 (citation for the whole package)
}
\examples{
egfr.schwartz (creatinine = 1.4, age = 10, height_cm = 90, sex = "Male",
  creatinine_units = "mg/dl")
egfr.schwartz (creatinine = 1.4, age = 10, height_cm = 90, sex = "Male",
  creatinine_units = "mg/dl", equation_type = "quadratic")
}
