% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{image_uri}
\alias{image_uri}
\title{Encode an image file to a data URI}
\usage{
image_uri(f)
}
\arguments{
\item{f}{Path to the image file.}
}
\value{
The data URI as a character string.
}
\description{
This function is the same as \code{xfun::\link{base64_uri}()} (only with a
different function name). It can encode an image file as a base64 string,
which can be used in the \code{img} tag in HTML.
}
\examples{
uri = image_uri(file.path(R.home("doc"), "html", "logo.jpg"))
if (interactive()) {
    cat(sprintf("<img src=\"\%s\" />", uri), file = "logo.html")
    browseURL("logo.html")  # you can check its HTML source
}
}
\references{
\url{https://en.wikipedia.org/wiki/Data_URI_scheme}
}
\author{
Wush Wu and Yihui Xie
}
