% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{AIC.lcc}
\alias{AIC.lcc}
\alias{BIC.lcc}
\title{Akaike and Bayesian Information Criteria for an \code{lcc} Object.}
\usage{
\method{AIC}{lcc}(object, ..., k = 2)

\method{BIC}{lcc}(object, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{lcc},
representing a fitted longitudinal concordance correlation
function.}

\item{...}{optional arguments passed to the \code{AIC}
function.}

\item{k}{numeric value, use as penalty coefficient for the number of
parameters in the fitted model; the default \code{k = 2} is the
classical AIC.}
}
\description{
Calculate the Akaike's 'An Information Criterion' or
  the BIC or SBC (Schwarz's Bayesian criterion) for an object of
  class \code{lcc}.
}
\details{
A numeric value with the corresponding AIC or BIC
  value. See methods for \code{\link{AIC}} objects to get more
  details.
}
\examples{
\dontrun{
attach(simulated_hue)
fm6 <- lcc(data = simulated_hue, subject = "Fruit",
           resp = "Hue", method = "Method", time = "Time",
           qf = 2, qr = 1, components = TRUE,
           time_lcc = list(n=50, from=min(Time), to=max(Time)))
AIC(fm6)
BIC(fm6)
}

}
\seealso{
\code{\link[lcc]{lcc}}, \code{\link{summary.lcc}},
  \code{\link{coef.lcc}}, \code{\link{vcov.lcc}}
}
\author{
Thiago de Paula Oliveira,
  \email{thiago.paula.oliveira@alumni.usp.br}
}
