% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state.R
\name{lx_delta}
\alias{lx_delta}
\title{Change light state relative to current state (wrapper for POST state delta}
\usage{
lx_delta(
  hue = NULL,
  saturation = NULL,
  brightness = NULL,
  kelvin = NULL,
  infrared = NULL,
  duration = 0,
  power = NULL,
  selector = "all",
  token = lx_get_token()
)
}
\arguments{
\item{hue}{set the hue (0-255)}

\item{saturation}{set the saturation (0-1)}

\item{brightness}{set the brightness (0-1)}

\item{kelvin}{set the color temperature. limits depend on the specific lamp; limits are likely in the range of 2500-9000}

\item{infrared}{infrared brightness (0-1)}

\item{duration}{in seconds, how long to perform the transition}

\item{power}{string - if set to "on", turns the light on, if set to "off" turns it off.}

\item{selector}{'LIFX' api "selector" such as "all", "id:12345", or "location:kitchen". Can be created with \code{\link{lx_selector}} or written manually (see \url{https://api.developer.lifx.com/docs/selectors}}

\item{token}{API token (see ?lx_save_token). If left empty, the token is retrieved from the environmental variable if available. (see \code{\link{lx_save_token}})}
}
\value{
an 'httr' response object (see \code{\link[httr]{response}})
}
\description{
Change light state relative to current state (wrapper for POST state delta
}
\references{
\url{https://api.developer.lifx.com/docs/state-delta}
}
