% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_lights.R
\name{lx_list_lights}
\alias{lx_list_lights}
\title{list available lights}
\usage{
lx_list_lights(selector = "all", token = lx_get_token())
}
\arguments{
\item{selector}{'LIFX' api "selector" such as "all", "id:12345", or "location:kitchen". Can be created with \code{\link{lx_selector}} or written manually (see \url{https://api.developer.lifx.com/docs/selectors}}

\item{token}{API token (see ?lx_save_token). If left empty, the token is retrieved from the environmental variable if available. (see \code{\link{lx_save_token}})}
}
\value{
a list with each item representing one light. Each item itself is a list with all relevant information about the light and it's state
}
\description{
list available lights
}
\details{
each item in the returned list contains (depending on the type of lamp), the following named items:

\itemize{
 \item{Reachability: }{\code{connected, last_seen, seconds_since_seen}}
 \item{Light identifiers / selectors: }{\code{id, uuid, label,  group, location}}
 \item{Status: }{\code{power, color, brightness, effect}}
 \item{Hardware information: }{\code{product}}
}
}
\examples{
\dontrun{
lx_list_lights()

lights <- lx_list_lights(
  lx_selector(location = "kitchen")
)

first_kitchen_light <- lights[[1]]

first_kitchen_light$power
first_kitchen_light$color$hue
first_kitchen_light$color$saturation

first_kitchen_light$group

}
}
