% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liminal-data.R
\docType{data}
\name{pdfsense}
\alias{pdfsense}
\title{Parton distribution function sensitivity experiments}
\format{
An object of class \code{data.frame} with 2808 rows and 62 columns.
}
\source{
\url{http://www.physics.smu.edu/botingw/PDFsense_web_histlogy/}
}
\usage{
pdfsense
}
\description{
Data from Wang et al., 2018 to compare embedding approaches to a
tour path.
}
\details{
Data were obtained from CT14HERA2 parton distribution function
fits as used in Laa et al., 2018. There are 28 directions in the parameter
space of parton distribution function fit, each point in the variables
labelled X1-X56 indicate moving +- 1 standard devation from the 'best'
(maximum likelihood estimate) fit of the function. Each observation has
all predictions of the corresponding measurement from an experiment.

(see table 3 in that paper for more explicit details).

The remaining columns are:
\itemize{
\item InFit: A flag indicating whether an observation entered the fit of
CT14HERA2 parton distribution function
\item Type: First number of ID
\item ID: contains the identifier of experiment, 1XX/2XX/5XX correpsonds
to Deep Inelastic Scattering (DIS) / Vector Boson Production (VBP) /
Strong Interaction (JET). Every ID points to an experimental paper.
\item pt: the per experiment observational id
\item x,mu: the kinematics of a parton. x is the parton momentum fraction, and
mu is the factorisation scale.
}
}
\references{
Wang, B.-T., Hobbs, T. J., Doyle, S., Gao, J., Hou, T.-J., Nadolsky, P. M.,
& Olness, F. I. (2018). PDFSense: Mapping the sensitivity of
hadronic experiments to nucleon structure.
Retrieved from \url{https://arxiv.org/abs/1808.07470}

Cook, D., Laa, U., & Valencia, G. (2018).
Dynamical projections for the visualization of PDFSense data.
The European Physical Journal C, 78(9), 742.
\doi{10.1140/epjc/s10052-018-6205-2}
}
\keyword{datasets}
