% Generated by roxygen2 (4.0.2): do not edit by hand
\name{vgam.crc.boots}
\alias{vgam.crc.boots}
\title{Bootstrapping for a VGAM CRC model}
\usage{
vgam.crc.boots(boot.list)
}
\arguments{
\item{boot.list}{A list of control parameters for the bootstrapping process.
See the example under \code{lllcrc-package}}
}
\value{
A list containing two vectors.  The first vector, \code{cpi0}, gives
the estimated number of missing units at each point; the second, \code{mct},
gives the number of units observed at each point.  (Dividing the first
vector by the second gives an estimate rate of missingness)
}
\description{
Implement a single instance of resampling process to simulate a replicate of
the \code{vgam.crc} model.
}
\details{
\code{vgam.crc} calls this function for each bootstrap replicate.  Many
replicates together can be used for empirical confidence interval
estimation.  The bootstrap is much like that described by Zwane 2003, but
more like Method 2 in Norris and Polluck 1996, as we repeat the process of
selecting log-linear terms for each bootstrap iteration, and the multinomial
sampling probabilities are based on raw local estimates instead of
post-log-linear modeling estimates.
}
\author{
Zach Kurtz
}
\references{
Norris JL and Pollock KH (1996). "Including model uncertainty in
estimating variances in multiple capture studies." \emph{Environmental and
Ecological Statistics}, \bold{3}, pp. 235-244.
}

