% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longitudinal_consensus_cluster.R
\name{longitudinal_consensus_cluster}
\alias{longitudinal_consensus_cluster}
\title{Longitudinal consensus clustering with flexmix}
\usage{
longitudinal_consensus_cluster(
  data = NULL,
  id_column = NULL,
  max_k = 3,
  reps = 10,
  p_item = 0.8,
  model_list = NULL,
  flexmix_formula = as.formula("~s(visit, k = 4) | patient_id"),
  title = "untitled_consensus_cluster",
  final_linkage = c("average", "ward.D", "ward.D2", "single", "complete", "mcquitty",
    "median", "centroid"),
  seed = 3794,
  verbose = FALSE
)
}
\arguments{
\item{data}{a \code{data.frame} with one or several observations per subject.
It needs to contain one column that specifies to which subject the entry (row)
belongs to. This ID column is specified in \code{id_column}. Otherwise, there
are no restrictions on the column names, as the model is specified in
\code{flexmix_formula}.}

\item{id_column}{name (character vector) of the ID column in \code{data} to
identify all observations of one subject}

\item{max_k}{maximum number of clusters, default is \code{3}}

\item{reps}{number of repetitions, default is \code{10}}

\item{p_item}{fraction of samples contained in subsampled sample, default is
\code{0.8}}

\item{model_list}{either one \code{flexmix} driver or a list of \code{flexmix}
drivers of class \code{FLXMR}}

\item{flexmix_formula}{a \code{formula} object that describes the \code{flexmix}
model relative to the formula in the flexmix drivers (the dot in the flexmix
drivers is replaced, see the example). That means that you usually only
specify the right-hand side of the formula here. However, this is not enforced
or checked to give you more flexibility over the \code{flexmix} interface}

\item{title}{name of the clustering; used if \code{writeTable = TRUE}}

\item{final_linkage}{linkage used for the last hierarchical clustering step on
the consensus matrix; has to be \code{average, ward.D, ward.D2, single, complete, mcquitty, median}
or \code{centroid}. The default is \code{average}}

\item{seed}{seed for reproducibility}

\item{verbose}{\code{boolean} if status messages should be displayed.
Default is \code{FALSE}}
}
\value{
An object (list) of class \code{lcc} with length \code{maxk}.
The first entry \code{general_information} contains the entries:\tabular{ll}{
\code{consensus_matrices} \tab a list of all consensus matrices (for all specified clusters) \cr
\tab \cr
\code{cluster_assignments} \tab a \code{data.frame} with an ID column named after \code{id_column} and a column for every specified number of clusters, e.g. \code{assignment_num_clus_2} \cr
\tab \cr
\code{call} \tab the call/all arguments how \code{longitudinal_consensus_cluster} was called
}

The other entries correspond to the number of specified clusters (e.g. the
second entry corresponds to 2 specified clusters) and each contains a list with the
following entries:\tabular{ll}{
\code{consensus_matrix} \tab the consensus matrix \cr
\tab \cr
\code{consensus_tree} \tab the result of the hierarchical clustering on the consensus matrix \cr
\tab \cr
\code{consensus_class} \tab the resulting class for every observation \cr
\tab \cr
\code{found_flexmix_clusters} \tab a vector of the actual found number of clusters by \code{flexmix} (which can deviate from the specified number)
}
}
\description{
This function performs longitudinal clustering with flexmix. To get robust
results, the data is subsampled and the clustering is performed on this
subsample. The results are combined in a consensus matrix and a final
hierarchical clustering step performed on this matrix. In this, it follows
the approach from the \code{ConsensusClusterPlus} package.
}
\details{
The data types \code{longitudinal_consensus_cluster} can handle depends on
how the \code{flexmix} models are set up, in principle all data types are
supported for which there is a \code{flexmix} driver with the desired
outcome variable.

If you follow the dimension reduction approach outlined in
\code{vignette("Example clustering analysis", package = "longmixr")}, the
input data types depend on what \code{FAMD} from the \code{FactoMineR}
package can handle. \code{FAMD} accepts \code{numeric} variables and treats
all other variables as \code{factor} variables which it can handle as well.
}
\examples{
set.seed(5)
test_data <- data.frame(patient_id = rep(1:10, each = 4),
visit = rep(1:4, 10),
var_1 = c(rnorm(20, -1), rnorm(20, 3)) +
rep(seq(from = 0, to = 1.5, length.out = 4), 10),
var_2 = c(rnorm(20, 0.5, 1.5), rnorm(20, -2, 0.3)) +
rep(seq(from = 1.5, to = 0, length.out = 4), 10))
model_list <- list(flexmix::FLXMRmgcv(as.formula("var_1 ~ .")),
flexmix::FLXMRmgcv(as.formula("var_2 ~ .")))
clustering <- longitudinal_consensus_cluster(
data = test_data,
id_column = "patient_id",
max_k = 2,
reps = 3,
model_list = model_list,
flexmix_formula = as.formula("~s(visit, k = 4) | patient_id"))
# not run
# plot(clustering)
# end not run
}
