% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{add_layer}
\alias{add_layer}
\title{Add a layer to the map}
\usage{
add_layer(map, style, popup = NULL)
}
\arguments{
\item{map}{A \link{mapboxer} object.}

\item{style}{A named list that defines the style of the layer.
See \url{https://docs.mapbox.com/mapbox-gl-js/style-spec/layers/} for available style options
for the used layer type.}

\item{popup}{A \href{https://github.com/janl/mustache.js}{mustache} template
in which the tags refer to the properties of the layer's data object.}
}
\description{
Adds any kind of layer to the map.
The type of the layer is specified by the \code{type} property of the
layer definintion.
}
\examples{
image_src <- mapbox_source(
  type = "image",
  url = "https://docs.mapbox.com/mapbox-gl-js/assets/radar.gif",
  coordinates = list(
    c(-80.425, 46.437),
    c(-71.516, 46.437),
    c(-71.516, 37.936),
    c(-80.425, 37.936)
  )
)

raster_style <- list(
  id = "overlay",
  type = "raster",
  source = image_src,
  paint = list(
    "raster-opacity" = 0.85
  )
)

map <- mapboxer(
  center = c(-75.789, 41.874),
  zoom = 5
) \%>\%
  add_layer(raster_style)

if (interactive()) map
}
\seealso{
\link{add_popups} for an example of a mustache template used to generate the popup text.
}
