% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/minimumDistanceMethod.R
\name{md}
\alias{md}
\title{md selects bandwidth for kernel density estimator
with minimum distance method. Minimum distance method
directly selects optimal kernel density estimator
in countably infinite kernel density estimators
and indirectly selects optimal bandwidth.
md selects optimal bandwidth in countably finite
kernel density estimators.}
\usage{
md(data,hnumber,ds)
}
\arguments{
\item{data}{data sample}

\item{hnumber}{the number of bandwidth which md can select.
60 is enough. Of course, you can take it more.}

\item{ds}{rate of data split. Minimum distance method has to split
         data for constructing kernel density estimators and
         empirical measures.}
}
\value{
bandwidth
}
\description{
md selects bandwidth for kernel density estimator
with minimum distance method. Minimum distance method
directly selects optimal kernel density estimator
in countably infinite kernel density estimators
and indirectly selects optimal bandwidth.
md selects optimal bandwidth in countably finite
kernel density estimators.
}
\examples{
# select bandwidth
md(runif(100),20,0.6)

# select bandwidth and plot
data <- rnorm(100)
bandwidth <- md(data,20,0.6)
x <- seq(min(data),max(data),length=100)
plot(x,sapply(x,fhat,bandwidth,data),type="l",ylab="density")
}

