% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storage.R
\name{storage.init}
\alias{storage.init}
\title{Initialize a store.}
\usage{
storage.init(storage.type = "memory", ...)
}
\arguments{
\item{storage.type}{storage type to initialize, defaults to \code{memory}}

\item{...}{additional configuration values used by storage implementations}
}
\value{
List containing characteristics perticular to the storage implementation, including:
\itemize{
   \item{\code{$type} - the storage type}
}
}
\description{
Initlaize storage for name value pairs based on provided type.

Available types of storage include:
\itemize{
   \item{\code{memory} - transient in-memory storage}
   \item{\code{file} - persistent storage, using local file storage}
}

Additional paramters may be provided when initializing different types of storage.  

See specific storage types for details.
}
\examples{
library(magrittr)

# initialize default memory storage
my.storage <- storage.init()

# set a value into storage
storage.set(my.storage, "name", "Roy Wetherall")

# .. and some more
my.storage \%>\% 
  storage.set("age", 45) \%>\% 
  storage.set("alive", TRUE) \%>\%
  storage.set("children", c("Peter", "Grace", "Lucy"))

# check a key has been set
if (storage.has(my.storage, "name")) print("I know your name!")

# .. and that a key hasn't been set
if (!storage.has(my.storage, "address")) print("I don't know where you live!")

# get some values from storage
sprintf(
  "\%s is \%i years old.", 
  storage.get(my.storage, "name"),
  storage.get(my.storage, "age"))

# remove a value from storage
storage.unset(my.storage, "children")

# .. and show it's not there anymore
if (!storage.has(my.storage, "address")) print("I don't know who your children are!")

# clear all values from storage
storage.clear(my.storage)

# .. and everything is gone
if (!storage.has(my.storage, "name") && !storage.has(my.storage, "age")) print("I know nothing!")
}
