% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subgroup_power.R
\name{subgroup_power}
\alias{subgroup_power}
\title{Compute Power for Subgroup Analysis in Meta-analysis}
\usage{
subgroup_power(
  n_groups,
  effect_sizes,
  study_size,
  k,
  i2 = 0.5,
  es_type,
  p = 0.05,
  con_table = NULL
)
}
\arguments{
\item{n_groups}{Numerical value for the number of subgroups.}

\item{effect_sizes}{Numerical values for effect sizes of for each group.}

\item{study_size}{Numerical value for number of participants (per study).}

\item{k}{Numerical value for total number of studies.}

\item{i2}{Numerical value for Heterogeneity estimate (i^2).}

\item{es_type}{Character reflecting effect size metric: 'r', 'd', or 'or'.}

\item{p}{Numerical value for significance level (Type I error probability).}

\item{con_table}{(Optional) List of numerical values for 2x2 contingency
    tables as a vector in the following format: c(a,b,c,d). These should be
    specified for each subgroup (i.e., n_groups).

\tabular{lcc}{
 2x2 Table   \tab Group 1 \tab Group 2 \cr
 Present     \tab a       \tab b       \cr
 Not Present \tab c       \tab d       \cr
}}
}
\value{
Estimated Power estimates for subgroup differences under fixed- and random-effects models
}
\description{
Computes statistical power for different subgroups under fixed and random effects models.
}
\examples{
subgroup_power(n_groups = 2,
               effect_sizes = c(.1,.5),
               study_size = 20,
               k = 10,
               i2 = .5,
               es_type = "d")
subgroup_power(n_groups = 2,
               con_table = list(g1 = c(6,5,4,5), g2 = c(8,5,2,5)),
               study_size = 40,
               k = 20,
               i2 = .5,
               es_type = "or")

}
\seealso{
\url{https://jason-griffin.shinyapps.io/shiny_metapower/}
}
