% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrix_table_template.R
\name{metrix_table_template}
\alias{metrix_table_template}
\title{Metrix data template}
\usage{
metrix_table_template(store = FALSE)
}
\arguments{
\item{store}{A logical value indicating if the user want to store the results in a file.#'}
}
\value{
The function returns:
\item{template_table}{A table that can be used as input for other metrix functions.}
}
\description{
Metrix compatible table format template creation
}
\details{
This function creates a properly formatted table for being used with metrix functions. \cr The format of the input table must contain 8 columns that refer to the scientific and functional classification of the taxa. The first 7 columns refer to Class, Order, Family, Subfamily, Tribe, Genus and Species. Special care must be taken when entering the taxa nomenclature, because if it is misspelled, the package will not take this classification into account. It is not necessary to put genera and species in italics. Column 8 refers to the functional group of the taxa, which can be filtering collectors (FC), gathering collectors (GC), predators (P), scrapers (SCR) and shredders (SHR). After these columns, the places where you want to calculate the packet metrics are entered. It is essential that the site data are located after these taxonomic and functional classification columns. The user will be able to load the table with the amount of taxa and sites, as desired. \cr If store = TRUE the function will create a .csv file with properly named columns and saves it as template.csv on the current working directory.
}
\author{
Juan Manuel Cabrera and Julieta Capeleti.
}
