% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wordcloud.R
\name{plot_wordcloud}
\alias{plot_wordcloud}
\title{Create wordcloud of terms associated with a miRNA name}
\usage{
plot_wordcloud(
  df,
  mir,
  min.freq = 1,
  max.terms = 20,
  tf.idf = FALSE,
  token = "words",
  ...,
  stopwords = stopwords_miretrieve,
  stopwords_ngram = TRUE,
  colours = "black",
  random.colour = TRUE,
  ordered.colour = FALSE,
  col.mir = miRNA,
  col.abstract = Abstract,
  col.pmid = PMID
)
}
\arguments{
\item{df}{Data frame containing miRNA names, abstracts, and PubMed-IDs.}

\item{mir}{String. miRNA name of interest.}

\item{min.freq}{Integer. Specifies least number of times a term must be associated with
\code{mir} to be plotted.}

\item{max.terms}{Integer. Maximum number of terms to plot.}

\item{tf.idf}{Boolean. If \code{tf.idf = TRUE}, terms are weighed in a tf-idf
fashion. miRNA names are considered as separate documents, and terms often
associated with one miRNA, but not with other miRNAs get more weight.
Cannot be used if \code{normalize = TRUE}. If \code{tf.idf = TRUE} and \code{normalize = TRUE},
\code{tf.idf = TRUE} is ignored.}

\item{token}{String. Specifies how abstracts shall be split up. Taken from
\code{unnest_tokens()} in the \pkg{tidytext} package:
"Unit for tokenizing, or a custom tokenizing function. Built-in options are
"words" (default), "characters", "character_shingles", "ngrams", "skip_ngrams",
"sentences", "lines", "paragraphs", "regex",
(...),
and "ptb" (Penn Treebank). If a function, should take a character vector and
return a list of character vectors of the same length."}

\item{...}{Additional arguments for tokenization, if necessary.}

\item{stopwords}{Data frame containing stop words.}

\item{stopwords_ngram}{Boolean. Specifies if stop words shall be removed
from abstracts when using ngrams. Only applied when \code{token = 'ngrams'}.}

\item{colours}{Vector of strings. Colours for wordcloud.}

\item{random.colour}{Boolean. Taken from \code{wordcloud()} in the
\pkg{wordcloud} package:
"Choose colours randomly from \code{colours}. If false, the colour is chosen
based on the frequency."}

\item{ordered.colour}{Boolean. Taken from \code{wordcloud()} in the
\pkg{wordcloud} package:
"If true, then colours are assigned to words in order."}

\item{col.mir}{Symbol. Column containing miRNA names.}

\item{col.abstract}{Symbol. Column containing abstracts.}

\item{col.pmid}{Symbol. Column containing PubMed-IDs.}
}
\value{
Wordcloud of terms associated with a miRNA name.
}
\description{
Create wordcloud of terms associated with a miRNA name.
}
\details{
Create wordcloud of terms associated with a miRNA name.
miRNA names must be in a data frame \code{df}, while terms are taken
from abstracts contained in \code{df}.
Number of terms to plot is regulated by \code{max.terms}, while \code{min.freq} regulates
the least number of times a term must be mentioned to be plotted.
Terms can either be evaluated as their raw count, e.g. how often they are
mentioned in conjunction with the miRNA of interest, or weighed in a tf-idf
fashion. If \code{tf.idf = TRUE}, miRNA names are considered as separate documents,
and terms often associated with one miRNA, but not with other miRNAs get
more weight.
\code{plot_wordcloud()} is based on the tools available in the \pkg{wordcloud}
package.
}
\seealso{
\code{\link[=plot_mir_terms]{plot_mir_terms()}}, \code{\link[wordcloud:wordcloud]{wordcloud::wordcloud()}}, \code{\link[tidytext:unnest_tokens]{tidytext::unnest_tokens()}}

Other miR term functions: 
\code{\link{plot_mir_terms}()}
}
\concept{miR term functions}
