% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomedistances.R
\name{fluidity}
\alias{fluidity}
\title{Computing genomic fluidity for a pan-genome}
\usage{
fluidity(pan.matrix, n.sim = 10)
}
\arguments{
\item{pan.matrix}{A pan-matrix, see \code{\link{panMatrix}} for details.}

\item{n.sim}{An integer specifying the number of random samples to use in the computations.}
}
\value{
A vector with two elements, the mean fluidity and its sample standard deviation over
the \samp{n.sim} computed values.
}
\description{
Computes the genomic fluidity, which is a measure of population diversity.
}
\details{
The genomic fluidity between two genomes is defined as the number of unique gene
families divided by the total number of gene families (Kislyuk et al, 2011). This is averaged
over \samp{n.sim} random pairs of genomes to obtain a population estimate.

The genomic fluidity between two genomes describes their degree of overlap with respect to gene
cluster content. If the fluidity is 0.0, the two genomes contain identical gene clusters. If it
is 1.0 the two genomes are non-overlapping. The difference between a Jaccard distance (see
\code{\link{distJaccard}}) and genomic fluidity is small, they both measure overlap between
genomes, but fluidity is computed for the population by averaging over many pairs, while Jaccard
distances are computed for every pair. Note that only presence/absence of gene clusters are
considered, not multiple occurrences.

The input \samp{pan.matrix} is typically constructed by \code{\link{panMatrix}}.
}
\examples{
# Loading a pan-matrix in this package
data(xmpl.panmat)

# Fluidity based on this pan-matrix
fluid <- fluidity(xmpl.panmat)

}
\references{
Kislyuk, A.O., Haegeman, B., Bergman, N.H., Weitz, J.S. (2011). Genomic fluidity:
an integrative view of gene diversity within microbial populations. BMC Genomics, 12:32.
}
\seealso{
\code{\link{panMatrix}}, \code{\link{distJaccard}}.
}
\author{
Lars Snipen and Kristian Hovde Liland.
}
