% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRdist.R
\name{LRdist}
\alias{LRdist}
\title{Likelihood ratio distribution: a function for plotting expected log10(LR) distributions under relatedness and unrelatedness.}
\usage{
LRdist(datasim, type = 1)
}
\arguments{
\item{datasim}{Input dataframe containing expected LRs for related and unrelated POIs. It should be the output from makeLRsims function.}

\item{type}{Select between a density plot (type = 1, default) or a violin plot (type = 2).}
}
\value{
A plot showing likelihood ratio distributions under relatedness and unrelatedness hypothesis.
}
\description{
Likelihood ratio distribution: a function for plotting expected log10(LR) distributions under relatedness and unrelatedness.
}
\examples{
library(forrel)
x = linearPed(2)
x = setMarkers(x, locusAttributes = NorwegianFrequencies[1:5])
x = profileSim(x, N = 1, ids = 2)[[1]]
datasim = simLRgen(x, missing = 5, 10, 123)
LRdist(datasim)
}
