% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_Mix_utils.R
\name{Mix}
\alias{Mix}
\alias{print.Mix}
\alias{is.Mix}
\title{Mixtures of Univariate Distributions}
\usage{
Mix(dist, discrete, w = NULL, theta.list = NULL, name = NULL, \dots)

is.Mix(x)

\method{print}{Mix}(x, ...)
}
\arguments{
\item{dist}{character string providing the (abbreviated) name of the component distribution, such that the function \code{ddist} evaluates its density function and \code{rdist} generates random numbers. The function sources functions for the density/mass estimation and random variate generation from distributions in \code{\link[stats]{distributions}}, so the abbreviations should be specified accordingly. Thus to create a gaussian mixture, set \code{dist = "norm"}, for a poisson mixture, set \code{dist = "pois"}. The \code{Mix} function will find the functions \code{dnorm}, \code{rnorm} and \code{dpois}, \code{rpois} respectively.}

\item{discrete}{logical flag, should be set to TRUE if the mixture distribution is discrete and to FALSE if continuous.}

\item{w}{numeric vector of length \eqn{p}, specifying the mixture weights \eqn{w[i]} of the components, \eqn{i = 1,\dots,p}. If the weights do not add up to 1, they will be scaled accordingly. Equal weights for all components are used by default.}

\item{theta.list}{named list specifying the component parameters. The names of the list elements have to match the names of the formal arguments of the functions \code{ddist} and \code{rdist} exactly. For a gaussian mixture, the list elements would have to be named \code{mean} and \code{sd}, as these are the formal arguments used by \code{rnorm} and \code{dnorm} functions from \code{\link[stats]{distributions}}. Alternatively, the component parameters can be supplied directly as named vectors of length \eqn{p} via \dots}

\item{name}{optional name tag of the result (used for printing and plotting).}

\item{\dots}{\describe{
     \item{in \code{Mix()}:}{alternative way of supplying the component parameters (instead of using \code{theta.list}).}
     \item{in \code{print.Mix()}:}{further arguments passed to the print method.}
}}

\item{x}{\describe{
     \item{in \code{is.Mix()}:}{returns TRUE if the argument is a \code{datMix} object and FALSE otherwise.}
     \item{in \code{print.Mix()}:}{object of class \code{Mix}.}
}}
}
\value{
An object of class \code{Mix} (implemented as a matrix) with the following attributes:
    \item{dim}{dimensions of the matrix.}
    \item{dimnames}{a \code{\link[base]{dimnames}} attribute for the matrix.}
    \item{name}{optional name tag for the result passed on to printing and plotting methods.}
    \item{dist}{character string giving the abbreviated name of the component distribution, such that the function \code{ddist} evaluates its density/mass and \code{rdist} generates random variates.}
    \item{discrete}{logical flag indicating whether the mixture distribution is discrete.}
    \item{theta.list}{named list specifying component parameters.}
}
\description{
Function constructing objects of class \code{Mix} that represent finite mixtures of any univariate distribution. Additionally methods for printing and plotting are provided.
}
\examples{

# define 'Mix' object
normLocMix <- Mix("norm", discrete = FALSE, w = c(0.3, 0.4, 0.3), mean = c(10, 13, 17),
                  sd = c(1, 1, 1))
poisMix <- Mix("pois", discrete = TRUE, w = c(0.45, 0.45, 0.1), lambda = c(1, 5, 10))

# plot 'Mix' object
plot(normLocMix)
plot(poisMix)

}
\seealso{
\code{\link{dMix}} for the density, \code{\link{rMix}} for random numbers (and construction of an \code{rMix} object) and \code{\link{plot.Mix}} for the plot method.
}
\keyword{cluster}
