% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerClustHierarchical.R
\name{autoplot.LearnerClustHierarchical}
\alias{autoplot.LearnerClustHierarchical}
\title{Plot for Hierarchical Clustering Learners}
\usage{
\method{autoplot}{LearnerClustHierarchical}(object, type = "dend", ...)
}
\arguments{
\item{object}{(\link[mlr3cluster:mlr_learners_clust.agnes]{mlr3cluster::LearnerClustAgnes} | \link[mlr3cluster:mlr_learners_clust.diana]{mlr3cluster::LearnerClustDiana} | \link[mlr3cluster:mlr_learners_clust.hclust]{mlr3cluster::LearnerClustHclust}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{...}{(\code{any}):
Additional arguments, passed down to function \code{\link[factoextra:fviz_dend]{factoextra::fviz_dend()}} in package \CRANpkg{factoextra}.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Generates plots for hierarchical clusterers, depending on argument \code{type}:
\itemize{
\item \code{"dend"} (default): dendrograms using \CRANpkg{factoextra} package.
\item \code{"scree"}: scree plot that shows the number of possible clusters on x-axis and
the height on the y-axis.
}

Note that learner-specific plots are experimental and subject to change.
}
\section{Theme}{

The \code{\link[=theme_mlr3]{theme_mlr3()}} and viridis color maps are applied by default to all
\code{autoplot()} methods. To change this behavior set
\code{options(mlr3.theme = FALSE)}.
}

\examples{
library(mlr3)
library(mlr3cluster)
library(mlr3viz)

task = mlr_tasks$get("usarrests")

# agnes clustering
learner = mlr_learners$get("clust.agnes")
learner$train(task)
autoplot(learner)

# diana clustering
learner = mlr_learners$get("clust.diana")
learner$train(task)
autoplot(learner,
  k = learner$param_set$values$k, rect_fill = TRUE,
  rect = TRUE, rect_border = "red")

# hclust clustering
learner = mlr_learners$get("clust.hclust")
learner$train(task)
autoplot(learner, type = "scree")
}
