% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/iipmetric.r
\name{iipmetric}
\alias{iipmetric}
\title{Compute Intensity Inner Product Metrics}
\usage{
iipmetric(S1, S2, measure = "sim", tau = 1, M = NULL)
}
\arguments{
\item{S1}{marked point process data.}

\item{S2}{marked point process data.}

\item{measure}{\code{"sim"} for similarity and \code{"dist"} for distance. Default \code{"sim"}.}

\item{tau}{a parameter for filtering function.}

\item{M}{a precision matrix for filter of marks, i.e., exp( - r' M r) is used for filtering marks. It should be symmetric and positive semi-definite.}
}
\value{
Similarity or distance between two inputs (marked) point process S1 and S2.
}
\description{
For the analysis of point process, intensity function plays a central roll. Paiva et al. (2009) proposed to use the intensity function for defining the inner product between point process realizations.
}
\details{
\code{iipmetric} computes intensity inner product metric. Intensity function for the point process realization is estimated by kernel density estimator. This function adopts Gaussian kernels for the sake of computational efficiency.
}
\examples{
##The aftershock data of 26th July 2003 earthquake of M6.2 at the northern Miyagi-Ken Japan.
data(Miyagi20030626)
## time longitude latitude depth magnitude
## split events by 7-hour
sMiyagi <- splitMPP(Miyagi20030626,h=60*60*7,scaleMarks=TRUE)$S
N <- 10
tau <- 0.1
sMat <- matrix(0,N,N)
  cat("calculating intensity inner product...")
 for(i in 1:(N)){
   cat(i," ")
   for(j in i:N){
     S1 <- sMiyagi[[i]]$time;S2 <- sMiyagi[[j]]$time
    sMat[i,j] <- iipmetric(S1,S2,tau=tau,M=diag(1,4))
   }
 }
 sMat <- sMat+t(sMat)
 tmpd <- diag(sMat) <- diag(sMat)/2
 sMat <- sMat/sqrt(outer(tmpd,tmpd))
image(sMat)
}
\author{
Hideitsu Hino \email{hinohide@cs.tsukuba.ac.jp}, Ken Takano, Yuki Yoshikawa, and Noboru Murata
}
\references{
A.R.C. Paiva, I. Park, and J.C. Principe. A reproducing kernel Hilbert space framework for spike train signal processing, Neural Computation, Vol. 21(2), pp. 424-449, 2009.
}

