% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tSNE.R
\name{tSNE}
\alias{tSNE}
\title{t-Distributed Stochastic Neighbor Embedding}
\usage{
tSNE(X, Y = NULL, k = 2, perplexity = 30, n.iter = 1000, eta = 500,
  initial.momentum = 0.5, final.momentum = 0.8, early.exaggeration = 4,
  gain.fraction = 0.2, momentum.threshold.iter = 20,
  exaggeration.threshold.iter = 100, max.binsearch.tries = 50)
}
\arguments{
\item{X}{A data frame, data matrix, dissimilarity (distance) matrix or dist
object.}

\item{Y}{Initial k-dimensional configuration. If NULL, the method uses a
random initial configuration.}

\item{k}{Target dimensionality. Avoid anything other than 2 or 3.}

\item{perplexity}{A rough upper bound on the neighborhood size.}

\item{n.iter}{Number of iterations to perform.}

\item{eta}{The "learning rate" for the cost function minimization}

\item{initial.momentum}{The initial momentum used before changing}

\item{final.momentum}{The momentum to use on remaining iterations}

\item{early.exaggeration}{The early exaggeration applied to intial iterations}

\item{gain.fraction}{Undocumented}

\item{momentum.threshold.iter}{Number of iterations before using the final
momentum}

\item{exaggeration.threshold.iter}{Number of iterations before using the real
probabilities}

\item{max.binsearch.tries}{Maximum number of tries in binary search for
parameters to achieve the target perplexity}
}
\value{
The k-dimensional representation of the data.
}
\description{
Creates a k-dimensional representation of the data by modeling the
probability of picking neighbors using a Gaussian for the high-dimensional
data and t-Student for the low-dimensional map and then minimizing the KL
divergence between them. This implementation uses the same default parameters
as defined by the authors.
}
\examples{
# Iris example
emb <- tSNE(iris[, 1:4])
plot(emb, col=iris$Species)

}
\references{
L.J.P. van der Maaten and G.E. Hinton. _Visualizing
High-Dimensional Data Using t-SNE._ Journal of Machine Learning Research
9(Nov): 2579-2605, 2008.
}

