% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpcmp-package.R
\docType{data}
\name{fish}
\alias{fish}
\title{Fish data set}
\format{
A data frame with 70 observations on 4 variables.
\describe{
\item{lake}{name of the lakes}
\item{species}{number of fish species in lakes}
\item{area}{surface area (km squared) }
\item{latitude}{latitude of the lakes}
}
}
\usage{
data(fish)
}
\description{
This data set gives the the number of fish species in lakes of the world; to examine the
effect of the surface area of the lakes. The latitude of the lakes are also recorded.
}
\details{
This data set is also used to illustrate that the fitting algorithm can handle some
larger count data.
}
\examples{
### Barbour & Brown (1974): Overdispersed Fish data
\donttest{
data(fish)
M.fish <- glm.cmp(species~ 1+log(area), data=fish)
M.fish
summary(M.fish)
}
}
\references{
Barbour, C. D. and Brown, J. H. (1974). Fish species diversity in lakes. \emph{The
American Naturalist}, \bold{108}, 473--488.
}
\keyword{datasets}
