% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sim.R
\name{plot_sim}
\alias{plot_sim}
\title{Plot data arising from multivar_sim.}
\usage{
plot_sim(x, plot_type = "common", facet_ncol = 3, datasets = "all")
}
\arguments{
\item{x}{Object. An object returned by multivar_sim.}

\item{plot_type}{Character. User can specify "common" to plot the common effects matrix, "unique" to plot the unique effects matrix, or "total" to plot the total effects matrix.}

\item{facet_ncol}{Numeric. Number of columns to use in the "unique" or "total" effects plot.}

\item{datasets}{Numeric. A vector containing the index of datasets to plot. Default is "all".}
}
\description{
Plot data arising from multivar_sim.
}
\examples{

k <- 3
d <- 5
n <- 50
prop_fill_com <- .2
prop_fill_ind <- .2
lb <- 0.1
ub <- 0.7
sigma <- diag(0.1,d)
sim <- multivar_sim(k, d, n, prop_fill_com, prop_fill_ind, lb, ub,sigma)
plot_sim(sim, plot_type = "common")

}
\keyword{multivar}
\keyword{plot}
\keyword{simulate}
\keyword{var}
