% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mumm.methods.R
\name{confint.mumm}
\alias{confint.mumm}
\title{Confidence Intervals for Model Parameters}
\usage{
\method{confint}{mumm}(object, parm = "all", level = 0.95, ...)
}
\arguments{
\item{object}{an object of class mumm.}

\item{parm}{a vector of parameter names or a matrix, where the rows specify linear combinations of the model parameters. If missing,
confidence intervals will be computed for all of the fixed effect parameters and all of the variance components.}

\item{level}{the confidence level.}

\item{...}{Currently not used.}
}
\value{
A matrix with the first column showing the lower confidence limit and the second column showing the
upper limit for each parameter or linear combination of parameters.
}
\description{
Computes confidence intervals for the fixed effect parameters and the variance components
for an object of class \code{mumm}.
}
\details{
The confidence intervals are computed by the profile likelihood method.
}
\examples{
set.seed(100)
sigma_e <- 1.5
sigma_a <- 0.8
sigma_b <- 0.5
sigma_d <- 0.7
nu <- c(8.2, 6.2, 2.3, 10.4, 7.5, 1.9)

nA <- 15
nP <- 6
nR <- 5

a <- rnorm(nA, mean = 0, sd = sigma_a)
b <- rnorm(nA, mean = 0, sd = sigma_b)
d <- rnorm(nA*nP, mean = 0, sd = sigma_d)
e <- rnorm(nA*nP*nR, mean = 0, sd = sigma_e)

Assessor <- factor(rep(seq(1,nA),each = (nP*nR)))
Product <- factor(rep(rep(seq(1,nP),each = nR), nA))
AssessorProduct <- (Assessor:Product)

y <- nu[Product] + a[Assessor] + b[Assessor]*(nu[Product]-mean(nu)) + d[AssessorProduct] + e

sim_data <- data.frame(y, Assessor, Product)

fit <- mumm(y ~ 1 + Product + (1|Assessor) + (1|Assessor:Product) +
             mp(Assessor,Product) ,data = sim_data)
\donttest{
confint(fit, parm = c('Product3', 'mp Assessor:Product'), level = 0.90)
}

}
