% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncurl.R
\name{ncurl}
\alias{ncurl}
\title{ncurl}
\usage{
ncurl(
  url,
  async = FALSE,
  convert = TRUE,
  method = NULL,
  headers = NULL,
  data = NULL
)
}
\arguments{
\item{url}{the URL address.}

\item{async}{[default FALSE] logical value whether to perform actions async.}

\item{convert}{[default TRUE] logical value whether to attempt conversion of
the received raw bytes to a character vetor.}

\item{method}{(optional) the HTTP method (defaults to 'GET' if not specified).}

\item{headers}{(optional) a named list or character vector specifying the
HTTP request headers e.g. \code{list(`Content-Type` = "text/plain")} or
\code{c(Authorization = "Bearer APIKEY")}.}

\item{data}{(optional) the request data to be submitted.}
}
\value{
Named list of 2 elements:
    \itemize{
    \item{\code{$raw}} {- raw vector of the received resource (use
    \code{\link{writeBin}} to save to a file).}
    \item{\code{$data}} {- converted character string (if \code{'convert' = TRUE}
    and content is a recognised text format), or NULL otherwise. Other tools
    can be used to further parse this as html, json, xml etc. if required.}
    }

    Or else, if \code{async = TRUE}, a 'recvAio' (object of class 'recvAio').
}
\description{
nano cURL - a minimalist http(s) client.
}
\section{Redirects}{


    In interactive sessions: will prompt upon receiving a redirect location
    whether to follow or not (default: yes).

    In non-interactive sessions: redirects are never followed.

    For async requests, the redirect address will be returned as a character
    string at \code{$raw} and \code{$data} will be NULL.
}

\section{TLS Support}{


    Connecting to secure https sites is supported if \code{\link{nng_version}}
    shows 'TLS supported'.
}

\examples{
ncurl("http://httpbin.org/get")
ncurl("http://httpbin.org/put",,,"PUT", list(Authorization = "Bearer APIKEY"), "hello world")
ncurl("http://httpbin.org/post",,,"POST", c(`Content-Type` = "application/json"),'{"k":"v"}')

}
