% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{send_ctx}
\alias{send_ctx}
\title{Send over Context}
\usage{
send_ctx(context, data, mode = c("serial", "raw"), timeout = -2L, echo = TRUE)
}
\arguments{
\item{context}{a Context.}

\item{data}{an object (a vector, if mode = 'raw').}

\item{mode}{either 'serial' for sending serialised R objects, or 'raw' for
sending vectors of any type (converted to a raw byte vector for sending).
For Streams, 'raw' is the only choice and any other value is ignored. Use
'serial' for perfect reproducibility within R, although 'raw' must be used
when interfacing with external applications that do not understand R
serialisation.}

\item{timeout}{(optional) integer value in milliseconds. If unspecified, the
default of -2L uses a socket-specific default, which is usually the same
as no timeout.}

\item{echo}{[default TRUE] logical TRUE to return the raw vector of sent data,
or FALSE to return an integer exit code (invisibly).}
}
\value{
Raw vector of sent data, or (invisibly) an integer exit code (zero on
    success) if 'echo' is set to FALSE.
}
\description{
Send data over a Context [Deprecated].
}
\details{
Will block if the send is in progress and has not yet completed -
    certain protocol / transport combinations may limit the number of messages
    that can be queued if they have yet to be received. Set a timeout to
    ensure the function returns under all scenarios.
}
\keyword{internal}
