% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlyap.R
\name{dlyap}
\alias{dlyap}
\title{Discrete Lyapunov Equation Solver}
\usage{
dlyap(A, W)
}
\arguments{
\item{A}{\eqn{n x n} numeric or complex matrix.}

\item{W}{\eqn{n x n} numeric or complex matrix.}
}
\value{
The solution to the above Lyapunov equation.
}
\description{
Computes the solution of \eqn{AXA^T - X + W = 0} using the Barraud 1977 approach, adapted from Datta 2004.
 This implementation is equivalent to the Matlab implementation of dylap.
}
\examples{
A = matrix(c(0,-3,-2,2,-2,1,-1,2,-1), 3,3)
C = matrix(c(-2,-8,11,2,-6,13,-3,-5,-2), 3,3)
X = dlyap(t(A), C)

print(sum(abs(A \%*\% X \%*\% t(A) - X + C)))
}
\references{
\insertRef{barraud_numerical_1977}{netcontrol}

\insertRef{datta_numerical_2004}{netcontrol}
}
