% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nettskjema-codebook.R
\name{nettskjema_get_codebook}
\alias{nettskjema_get_codebook}
\title{Get codebook for a form}
\usage{
nettskjema_get_codebook(
  form_id,
  as_is = FALSE,
  token_name = "NETTSKJEMA_API_TOKEN",
  ...
)
}
\arguments{
\item{form_id}{integer. Number of the form to retrieve}

\item{as_is}{logical. Whether to return the raw content from nettskjema. Default is FALSE.}

\item{token_name}{character. Name to give the token, defaults to 'NETTSKJEMA_API_TOKEN'}

\item{...}{arguments passed to \code{\link[httr]{GET}}}
}
\value{
list of class nettskjema_meta_data
}
\description{
With the given API token, will retrieve
a list of all the forms you have access to
}
\examples{
\dontrun{
codebook_110000 <- nettskjema_get_codebook(110000)
}
}
