% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_games.R
\name{nhl_games}
\alias{nhl_games}
\alias{nhl_games_content}
\alias{nhl_games_feed}
\alias{nhl_games_boxscore}
\alias{nhl_games_linescore}
\title{Retrieve metadata on NHL games from the API}
\usage{
nhl_games(gameIds, element)

nhl_games_content(gameIds)

nhl_games_feed(gameIds)

nhl_games_boxscore(gameIds)

nhl_games_linescore(gameIds)
}
\arguments{
\item{gameIds}{\code{numeric()}, vector of one or more game ids. The
game id is a 10 digit number where the
\itemize{
\item first 4 digits identify the season of the game, for instance
2017 for the 2017-2018 season.
\item next 2 digits give the type of game, where
\itemize{
\item 01 - preseason,
\item 02 - regular season,
\item 03 - playoffs,
\item 04 - all-star.
}
\item final 4 digits identify the specific game number
\itemize{
\item for regular season and preseason games, this ranges from
0001 to the number of games played. That is 1271 for
seasons with 31 teams and 1230 for seasons with 30 teams.
\item for playoff games, the
\itemize{
\item second digit gives the round of the playoffs
\item third digit specifies the match-up
\item fourth digit specifies the game (out of 7)
}
}
}}

\item{element}{\code{character()} vector of one or more valid elements.
Currently the valid elements seem to be:
\itemize{
\item \code{"linescore"}
\item \code{"boxscore"}
\item \code{"content"}
\item \code{"feed/live"}
}}
}
\value{
\code{list}, with information on games, one element per game
and element combination.
}
\description{
Retrieve metadata on NHL games from the API
}
\section{Functions}{
\itemize{
\item \code{nhl_games_content}: Complex endpoint returning multiple types
of media relating to the game including videos of shots,
goals and saves.

\item \code{nhl_games_feed}: returns all data about a specified game id
including play data with on-ice coordinates and post-game
details like first, second and third stars and details about
shootouts. Note that the data returned is sizable, often over
30 000 lines.

\item \code{nhl_games_boxscore}: Returns far less detail than \code{nhl_games_feed()}
and may be more suitable for analyzing post-game statistics
including goals, shots, penalty minutes, blocked, takeaways, etc.

\item \code{nhl_games_linescore}: Returns even fewer details than
\code{nhl_games_boxscore()}. Has goals, shots on goal, power-play
and goalie pulled status, number of skaters and shootout
information if applicable.
}}

\examples{
\dontrun{
  # Get content for one game
  nhl_games(2017010001, "content")

  # Get both box score and content for 2 games
  nhl_games(c(2017010001, 2017010002), c("content", "boxscore"))

  # Get content for a game
  nhl_games_content(2017010001)

  # Get the game feed for a game
  nhl_games_feed(2017010001)

  # Get the box score for a game
  nhl_games_boxscore(2017010001)

  # Get the line score for a game
  nhl_games_linescore(2017010001)
}

}
