% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/006functions.R
\name{AICc}
\alias{AICc}
\alias{AICc.nmm}
\alias{AICc.default}
\alias{BIC.nmm}
\title{Adjusted Akaike's Information Criterion.}
\usage{
AICc(object, ..., k = 2)

\method{AICc}{nmm}(object, ..., k = 2)

\method{AICc}{default}(object, ..., k = 2)

\method{BIC}{nmm}(object, ..., k = 2)
}
\arguments{
\item{object}{Fitted \code{nmm} model.}

\item{...}{Not used.}

\item{k}{Multiplication factor.}
}
\value{
a numeric value with the corresponding AIC, AICc, BIC.
}
\description{
Calculates adjusted and Bayesian Information Criterion for \code{nmm} object
}
\examples{
library(systemfit)
data( ppine , package="systemfit")
hg.formula <- hg ~ exp( h0 + h1*log(tht) + h2*tht^2 + h3*elev)
dg.formula <- dg ~ exp( d0 + d1*log(dbh) + d2*hg + d3*cr)
labels <- list( "height.growth", "diameter.growth" )
model <- list( hg.formula, dg.formula )
start.values <- c(h0=-0.5, h1=0.5, h2=-0.001, h3=0.0001,
                  d0=-0.5, d1=0.009, d2=0.25, d3=0.005)
model.sur <- nlsystemfit( "SUR", model, start.values, data=ppine, eqnlabels=labels )
eq_c <- as.character(c(hg.formula, dg.formula))
parl <- c(paste0("h", 0:3),paste0("d", 0:3))
res <- nmm(ppine, eq_c=eq_c, start_v=start.values, par_c=parl,
eq_type = "cont", best_method = FALSE)
aa <- in2nmm(res, model.sur$b)
AICc(res)
AICc(aa)
AIC(res)
AIC(aa)
BIC(res)
BIC(aa)
}
