% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/000functions.R
\name{extract_attr_deriv}
\alias{extract_attr_deriv}
\title{\code{extract_attr_deriv} converts attributes(hessian/gradient) of \code{deriv()} into a 
matrix of character strings.}
\usage{
extract_attr_deriv(ex, attribute)
}
\arguments{
\item{ex}{Expression of derivative. Results of \code{deriv()}.}

\item{attribute}{"grad" for gradient or "hessian" for the Hessian matrix.}
}
\value{
Returns a matrix of character strings.
}
\description{
\code{extract_attr_deriv} converts attributes(hessian/gradient) of \code{deriv()} into a 
matrix of character strings.
}
\examples{
eq <- parse(text="2*(log(sin(x)/log(x)))+x^4*log(x)+cos(y+x)")
tt <- deriv(eq, c("x", "y"), hessian=TRUE)
g <- tt\%>\%extract_attr_deriv(., attribute = "grad")
h <- tt\%>\%extract_attr_deriv(., attribute = "hessian")
}
